package com.testor.module.hire.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 租赁库管理-客商基本信息
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_hire_depository_manage_base")
public class DepositoryManageBase implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 出租方全称
     */
    @TableField("lessor_full_name")
    @ApiModelProperty(value = "出租方全称")
    private String lessorFullName;

    /**
     * 出租方简称
     */
    @TableField("lessor_short_name")
    @ApiModelProperty(value = "出租方简称")
    private String lessorShortName;

    /**
     * 客商编号
     */
    @TableField("lessor_code")
    @ApiModelProperty(value = "客商编号")
    private String lessorCode;

    /**
     * 统一社会信用代码
     */
    @TableField("lessor_credit_code")
    @ApiModelProperty(value = "统一社会信用代码")
    private String lessorCreditCode;

    /**
     * 法人代表身份证号
     */
    @TableField("lessor_legal_person_code")
    @ApiModelProperty(value = "法人代表身份证号")
    private String lessorLegalPersonCode;

    /**
     * 出租方联系电话
     */
    @TableField("lessor_tel")
    @ApiModelProperty(value = "出租方联系电话")
    private String lessorTel;

    /**
     * 经营范围
     */
    @TableField("lessor_business_scope")
    @ApiModelProperty(value = "经营范围")
    private String lessorBusinessScope;

    /**
     * 所属单位id
     */
    @TableField("lessor_org_id")
    @ApiModelProperty(value = "所属单位id")
    private String lessorOrgId;

    /**
     * 所属单位
     */
    @TableField("lessor_org_name")
    @ApiModelProperty(value = "所属单位")
    private String lessorOrgName;

    /**
     * 父级所属单位
     */
    @TableField("lessor_parent_org_name")
    @ApiModelProperty(value = "父级所属单位")
    private String lessorParentOrgName;

    /**
     * 父级所属单位id
     */
    @TableField("lessor_parent_org_id")
    @ApiModelProperty(value = "父级所属单位id")
    private String lessorParentOrgId;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    @ApiModelProperty(value = "状态：0正常 1删除 2停用")
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;


    public static final String ID = "id";

    public static final String LESSOR_FULL_NAME = "lessor_full_name";

    public static final String LESSOR_SHORT_NAME = "lessor_short_name";

    public static final String LESSOR_CODE = "lessor_code";

    public static final String LESSOR_CREDIT_CODE = "lessor_credit_code";

    public static final String LESSOR_LEGAL_PERSON_CODE = "lessor_legal_person_code";

    public static final String LESSOR_TEL = "lessor_tel";

    public static final String LESSOR_BUSINESS_SCOPE = "lessor_business_scope";

    public static final String LESSOR_ORG_ID = "lessor_org_id";

    public static final String LESSOR_ORG_NAME = "lessor_org_name";

    public static final String LESSOR_PARENT_ORG_NAME = "lessor_parent_org_name";

    public static final String LESSOR_PARENT_ORG_ID = "lessor_parent_org_id";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

}
