package com.testor.module.hire.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.module.hire.entity.DepositoryManageBase;
import com.testor.module.hire.entity.vo.HireDepositoryDetailVo;
import com.testor.module.hire.entity.vo.HireDepositoryListVo;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * <p>
 * 租赁库管理-客商基本信息 服务类
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
public interface DepositoryManageBaseService extends IService<DepositoryManageBase> {

    BaseResponseList<HireDepositoryListVo> findHireDepositoryList(HireDepositoryListVo vo);

    /**
     * 查询租赁库详情
     *
     * @param id 租赁库ID
     * @return 返回租赁库详情对象HireDepositoryDetailVo
     */
    HireDepositoryDetailVo findHireDepositoryDetail(String id,String updateStatus);

    /**
     * 更新租赁库所属机构编码
     *
     * @param id      租赁库ID
     * @param orgCode 机构编码
     */
    void updateHireDepositoryOrgCode(String id, String orgCode);

    /**
     * 保存租赁库信息
     */
    BaseResponse<HireDepositoryDetailVo> saveHireDepositoryInfo(HireDepositoryDetailVo vo);


    FileDTO convertFileDto(String processCode, String fileId);



    void dowonLoadFile(String processCode, String id, String fileName, HttpServletResponse response) throws UnsupportedEncodingException;


    /**
     * 导入历史数据
     *
     * @param file 包含历史数据的文件
     */
    BaseResponse<String> historicalDataImport(MultipartFile file) throws IOException;

    BaseResponse<String> dataImport(MultipartFile file);
}
