package com.testor.module.iam.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: IamUser
 * @Description: IAM系统用户表
 * @Author: lm
 * @CreateTime: 2023/12/28 13:51
 * @Version: 1.0
 */
@Data
@TableName("iam_sys_user")
@AllArgsConstructor
@NoArgsConstructor
public class IamSysUser  {

    @TableId
    private String id;
    /**
     * 用户id
     */
    @JsonProperty(value="userid")
    @TableField("user_id")
    private String userId;
    /**
     * 电话号码
     */
    private String mobile;
    /**
     * 姓名
     */
    @TableField("name")
    private String name;
    /**
     * 成员所属主部门id
     */
    @JsonProperty(value="main_department")
    private String mainDepartment;
    /**
     * 成员所属部门id列表
     */
    @TableField(exist = false)
    private List<String> department;
    /**
     * 成员职位列表，与所属部门顺序一致
     */
    @TableField(exist = false)
    private List<String> positions;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 成员所属部门名称列表
     */
    @TableField(exist = false)
    private List<String> departmentName;
    /**
     * 成员所属部门路径列表
     */
    @TableField(exist = false)
    private List<String> departmentPath;
    /**
     * 性别,1表示男，2表示女
     */
    private Integer gender;
    /**
     * order
     */
    @TableField(exist = false)
    private String order;
    /**
     * enable
     */
    private String enable;
    /**
     * Ad账号
     */
    private String adAccount;
    /**
     * 座机
     */
    private String telephone;
    /**
     * 政治面貌
     */
    private String polity;
    /**
     * 证件类型
     */
    private String idType;
    /**
     * 证件号码
     */
    private String idCard;
    /**
     * 职级编码
     */
    private String levelCode;
    /**
     * 职级描述
     */
    private String levelName;
    /**
     * 人员类别
     */
    @TableField("psn_cl")
    private String psnCl;

    @ApiModelProperty("创建者")
    @TableField(exist = false)

    private String createBy;
    @ApiModelProperty("创建时间")

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @ApiModelProperty("最后一次更新者")

    private String updateBy;
    @ApiModelProperty("最后一次更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;
    @ApiModelProperty("备注")
    private String remarks;
}
