package com.testor.module.mq.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class WeatherEntity {

    @JsonProperty("uniq_id")
    private String uniqId;

    @JsonProperty("signal_level")
    private String signalLevel;

    @JsonProperty("signal_level_code")
    private String signalLevelCode;

    @JsonProperty("signal_type_code")
    private String signalTypeCode;

    @JsonProperty("issue_content")
    private String issueContent;

    @JsonProperty("sender")
    private String sender;

    @JsonProperty("sender_code")
    private String senderCode;

    @JsonProperty("sender_area_code")
    private String senderAreaCode;

    @JsonProperty("invalid")
    private Integer invalid;

    @JsonProperty("expires")
    private String expires;

    @JsonProperty("msg_type")
    private String msgType;

    @JsonProperty("record_id")
    private String recordId;

    @JsonProperty("record_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date recordTime;

    @JsonProperty("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
