package com.testor.module.partner.model.vo;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import com.testor.module.partner.model.domain.TPartnerCertificate;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 相关方机构员工对象 t_partner_staff
 *
 * @author testor-framework
 * @date 2022-06-01 14:18:06
 */
@Data
public class PartnerStaffDetailVO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id（修改必填）")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id(（修改必填）)")
    private String orgId;
    /**
     * 相关方机构id
     */
    @ApiModelProperty(value = "相关方机构id")
    private String partnerId;

    @ApiModelProperty(value = "相关方机构name")
    private String partnerName;

    @ApiModelProperty(value = "名称")
    private String name;
    /**
     * 0-女 1-男
     */
    @ApiModelProperty(value = "0-女 1-男", example = "0")
    private String sex;

    @ApiModelProperty(value = "工种", example = "0")
    private String workType;
    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证")
    private String idcard;
    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phone;
    /**
     * 资质状态（0-异常，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-异常，1-正常）", example = "0")
    private Integer certificateStatus;
    /**
     * 年龄(计算库中不存)
     */
    @ApiModelProperty(value = "年龄(计算库中不存)", example = "0")
    private Integer age;

    public Integer getAge() {
        if (!StrUtil.isBlank(getIdcard())) {
            return IdcardUtil.getAgeByIdCard(getIdcard());
        }
        return age;
    }

    @ApiModelProperty(value = "培训状态 0-未培训 1-已培训", example = "0")
    private String trainingStatus;


    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;

    @ApiModelProperty("资质")
    private List<TPartnerCertificate> certificateIdList;

    @ApiModelProperty("登陆账号")
    private String loginName;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("是否为相关方")
    private String isStaff;
    @ApiModelProperty("userid")
    private String userId;

}
