package com.testor.module.safe.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.dict.data.controller.SysDictDataController;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataComplexResponse;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataListResponse;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataRequest;
import com.testor.biz.sys.dict.type.model.domain.SysDictType;
import com.testor.biz.sys.dict.type.service.SysDictTypeService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.constant.StatusEnum;
import com.testor.common.core.utils.StringUtils;
import com.testor.common.util.FileUtil;
import com.testor.ddd.safetyControl.infrastructure.repository.equipment.dao.TSafeEquipmentTypeDao;
import com.testor.ddd.safetyControl.infrastructure.repository.space.dao.TSafeSpaceTypeDao;
import com.testor.ddd.safetyControl.infrastructure.repository.space.entity.TSafeSpaceTypeDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import com.testor.module.safe.model.domain.TSafeHazardStandard;
import com.testor.module.safe.model.dto.TSafeHazardStandardDropDTO;
import com.testor.module.safe.model.dto.TSafeHazardStandardEditDTO;
import com.testor.module.safe.model.dto.TSafeHazardStandardParam;
import com.testor.module.safe.model.vo.TSafeHazardOptionVO;
import com.testor.module.safe.model.vo.TSafeHazardStandardVO;
import com.testor.module.safe.service.TSafeHazardOptionService;
import com.testor.module.safe.service.TSafeHazardStandardService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

import static org.codehaus.groovy.runtime.StringGroovyMethods.split;

/**
 * 隐患巡检排查标准Controller
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:45
 */
@RestController
@RequestMapping("/module/safe/hazard/standard")
@Api(value = "TSafeHazardStandard", tags = "隐患巡检排查标准")
@Slf4j
public class TSafeHazardStandardController extends SuperController {
    @Autowired
    private TSafeHazardStandardService tSafeHazardStandardService;

    @Autowired
    private TSafeHazardOptionService tSafeHazardOptionService;

    @Autowired(required = false)
    private TSafeSpaceTypeDao tSafeSpaceTypeRepo;

    @Autowired(required = false)
    private TSafeEquipmentTypeDao tSafeEquipmentTypeDao;

    @Autowired(required = false)
    private SysDictTypeService sysDictTypeService;

    @Autowired(required = false)
    private SysDictDataController sysDictDataController;

    @Autowired
    private SysOrgService sysOrgService;

    @Value("${ureport.path}")
    private String path;

    @Resource
    private HttpServletResponse response;

    @Resource
    private HttpServletRequest request;


    /* Generated Method*/
    @ApiOperation(value = "新增 隐患巡检排查标准", notes = "Add TSafeHazardStandard")
    @PostMapping(value = "/add")
    public BaseResponse<TSafeHazardStandard> addEntity(@RequestBody TSafeHazardStandardEditDTO addRequest) {
        return tSafeHazardStandardService.addEntity(addRequest);
    }

    @ApiOperation(value = "获取 隐患巡检排查标准 ", notes = "Get TSafeHazardStandard By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TSafeHazardStandardVO> getById(String id) {
        BaseResponse<TSafeHazardStandardVO> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            QueryWrapper<TSafeHazardStandard> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("id", id);
            queryWrapper.eq("status", StatusEnum.USE.getCode());
            TSafeHazardStandard data = tSafeHazardStandardService.getOne(queryWrapper);

            if (ObjectHelper.isNotEmpty(data)) {
                String orgId = data.getOrgId();
                SysOrg one = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq(SysOrg.ORG_ID, orgId));

                data.setOrgName(one.getOrgName());
                TSafeHazardStandardVO tSafeHazardStandardVO = BeanHelper.beanToBean(data, TSafeHazardStandardVO.class);

                List<TSafeHazardOptionVO> byParentIdList = tSafeHazardOptionService.getCheckContent(id);
                tSafeHazardStandardVO.setTsafeHazardOptionEditDTOList(byParentIdList);

                if (StringUtils.isNotBlank(data.getStandardChild())){
                    String[] split = data.getStandardChild().split(",");
                    tSafeHazardStandardVO.setStandardType(split[split.length - 1]);
                }
                baseResponse.setData(tSafeHazardStandardVO);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 隐患巡检排查标准细则（根据标准id） ")
    @GetMapping(value = "/getOption")
    public BaseResponse<List<TSafeHazardOptionVO>> getOption(String id) {
        BaseResponse<List<TSafeHazardOptionVO>> baseResponse = new BaseResponse<>();
        List<TSafeHazardOptionVO> optionByParentIdList = tSafeHazardOptionService.getRulesList(id);
        baseResponse.setData(optionByParentIdList);
        return baseResponse;
    }

    @ApiOperation(value = "修改 隐患巡检排查标准 ", notes = "Update TSafeHazardStandard By Id")
    @PutMapping(value = "/update")
    public BaseResponse<TSafeHazardStandard> updateEntity(@RequestBody TSafeHazardStandardEditDTO updateRequest) {
        return tSafeHazardStandardService.updateEntity(updateRequest);
    }

    @ApiOperation(value = "修改 隐患巡检排查标准状态（改流程状态） ")
    @PutMapping(value = "/updateProcessStatus")
    public BaseResponse<String> updateStandardStatusEntity(@RequestBody TSafeHazardStandardEditDTO updateRequest) {
        return tSafeHazardStandardService.updateProcessStatusEntity(updateRequest);
    }

    /*@ApiOperation(value = "删除 隐患巡检排查标准 ", notes = "delete TSafeHazardStandard By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardStandardDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeHazardStandard data = new TSafeHazardStandard();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tSafeHazardStandardService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "批量删除隐患巡检排查标准", notes = "delete TSafeHazardStandard by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TSafeHazardStandardDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            *//* 批量删除 *//*
            List<TSafeHazardStandard> tSafeHazardStandardList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TSafeHazardStandard data = new TSafeHazardStandard();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tSafeHazardStandardList.add(data);
            }
            boolean result = tSafeHazardStandardService.updateBatchById(tSafeHazardStandardList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/


    @ApiOperation(value = "获取 标准分类类型")
    @GetMapping(value = "/getStandardType")
    public BaseResponse<Map<String, List<Object>>> standardType(String orgId) {
        BaseResponse<Map<String, List<Object>>> baseResponse = new BaseResponse<>();
        Map<String, List<Object>> map = new HashMap<>();

        // 空间
        List<TSafeSpaceTypeDO> tSafeSpaceTypeDOS = tSafeSpaceTypeRepo.selectList(new QueryWrapper<TSafeSpaceTypeDO>().eq("status", StatusEnum.USE.getCode()));

        TSafeEquipmentTypeDTOParam param = new TSafeEquipmentTypeDTOParam();
        // 设备
        IPage<TSafeEquipmentTypeVO> tSafeEquipmentTypeVOIPage = tSafeEquipmentTypeDao.listPage(new Page<>(), param);
        List<TSafeEquipmentTypeVO> records = tSafeEquipmentTypeVOIPage.getRecords();

        // 管理
        SysDictType one = sysDictTypeService.getOne(new QueryWrapper<SysDictType>().eq("dict_type", ""));

        SysDictDataRequest sysDictDataRequest = new SysDictDataRequest();
        sysDictDataRequest.setDictType("SAFE_HAZARD_STANDARD_TYPE");
        BaseResponse<SysDictDataComplexResponse> sysDictDataComplexResponseBaseResponse = sysDictDataController.listDataByType(sysDictDataRequest);
        List<SysDictDataListResponse> sysDictDataListResponses = sysDictDataComplexResponseBaseResponse.getData().getData();

        map.put("空间", Collections.singletonList(tSafeSpaceTypeDOS));
        map.put("设备", Collections.singletonList(records));
        map.put("管理", Collections.singletonList(sysDictDataListResponses));

        baseResponse.setData(map);
        return baseResponse;
    }

    @ApiOperation(value = "获取 隐患巡检排查标准 分页列表", notes = "List TSafeHazardStandard with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TSafeHazardStandard>> listEntity(TSafeHazardStandardParam param) {
        BaseResponse<BaseResponseList<TSafeHazardStandard>> baseResponse = new BaseResponse<>();
        Long page = StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeHazardStandard> resultPage = new Page<>(page, limit);
        QueryWrapper<TSafeHazardStandard> queryWrapper = this.createQuery(param);

        Page<TSafeHazardStandard> resultList = tSafeHazardStandardService.page(resultPage, queryWrapper);
        BaseResponseList<TSafeHazardStandard> baseResponseList = new BaseResponseList<>();
        Map<String, String> orgNameMap = new HashMap<>(16);
        List<TSafeHazardStandard> records = resultList.getRecords();
        for (TSafeHazardStandard record : records) {
            String recordsOrgId = record.getOrgId();
            String orgName = orgNameMap.get(recordsOrgId);
            if (StringHelper.isEmpty(orgName)) {
                SysOrg one = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq(SysOrg.ORG_ID, recordsOrgId));
                orgName = one.getOrgName();
                orgNameMap.put(recordsOrgId, orgName);
            }
            record.setOrgName(orgName);
        }
        baseResponseList.setData(records);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 隐患巡检排查标准 列表 下拉使用", notes = "List TSafeHazardStandard all")
    @GetMapping(value = "/datasDropDown")
    public BaseResponse<BaseResponseList<TSafeHazardStandardDropDTO>> listAllEntity(TSafeHazardStandardParam param) {
        BaseResponse<BaseResponseList<TSafeHazardStandardDropDTO>> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        String orgName = curUser.getOrgName();
        String orgId = curUser.getOrgId();
        String parentIds = curUser.getParentIds();
        String[] split = parentIds.split(",");

        int length = split.length;

        List<TSafeHazardStandardDropDTO> list = new ArrayList<>();

        for (String s : split) {
            if ("0".equals(s)) {

                TSafeHazardStandardDropDTO tSafeHazardStandardDropDTO = new TSafeHazardStandardDropDTO();
                tSafeHazardStandardDropDTO.setId(orgId);
                tSafeHazardStandardDropDTO.setStandardName(orgName);

                QueryWrapper<TSafeHazardStandard> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("org_id", orgId);
                String standardType = param.getStandardType();
                if (StringHelper.isNotEmpty(standardType)) {
                    queryWrapper.eq("standard_type", standardType);
                }
                String standardChild = param.getStandardChild();
                if (StringHelper.isNotEmpty(standardChild)) {
                    queryWrapper.eq("standard_child", standardChild);
                }
                queryWrapper.eq("status", StatusEnum.USE.getCode());
                queryWrapper.eq("process_status", "5");

                List<TSafeHazardStandard> resultList = tSafeHazardStandardService.list(queryWrapper);
                tSafeHazardStandardDropDTO.setStandardList(resultList);

                list.add(tSafeHazardStandardDropDTO);
            } else {

                SysOrg one = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq(SysOrg.ORG_ID, s));

                TSafeHazardStandardDropDTO tSafeHazardStandardDropDTO = new TSafeHazardStandardDropDTO();
                tSafeHazardStandardDropDTO.setId(one.getOrgId());
                tSafeHazardStandardDropDTO.setStandardName(one.getOrgName());

                QueryWrapper<TSafeHazardStandard> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("org_id", one.getOrgId());
                String standardType = param.getStandardType();
                if (StringHelper.isNotEmpty(standardType)) {
                    queryWrapper.eq("standard_type", standardType);
                }
                String standardChild = param.getStandardChild();
                if (StringHelper.isNotEmpty(standardChild)) {
                    queryWrapper.eq("standard_child", standardChild);
                }
                queryWrapper.eq("status", StatusEnum.USE.getCode());
                queryWrapper.eq("process_status", "5");

                List<TSafeHazardStandard> resultList = tSafeHazardStandardService.list(queryWrapper);
                tSafeHazardStandardDropDTO.setStandardList(resultList);
                list.add(tSafeHazardStandardDropDTO);
            }
        }
        BaseResponseList<TSafeHazardStandardDropDTO> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(list);
        baseResponseList.setTotal(list.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "批量导入巡检标准", notes = "")
    @PostMapping("/importStandard")
    public BaseResponse<String> importStandard(@RequestParam("file") MultipartFile file) throws Exception {
        return tSafeHazardStandardService.addReportByExcel(file);
    }


    @ApiOperation(value = "导出巡检排查模板", notes = "")
    @GetMapping("/exportStandard")
    public void exportStandard() throws Exception {
        UserInfo loginUser = ContextUtils.getLoginUser();
        String orgId = loginUser.getOrgId();

        List<Map<String, String>> mapList = new ArrayList<>();


        String url = this.path + "/ureport/excel?_u=file:safeHazardStandard.ureport.xml";

        String url2 = this.path + "/ureport/excel?_u=file:safeHazardStandardRemark.ureport.xml";

        String url3 = this.path + "/ureport/excel?_u=file:safeHazardStandardType.ureport.xml";
        //参考文件企业信息
        String url1 = path + "/ureport/excel?_u=file:DowAptitudeCompanyMessage.ureport.xml&orgId=" + orgId;

        Map<String, String> map = new HashMap<>();
        Map<String, String> map1 = new HashMap<>();
        Map<String, String> map2 = new HashMap<>();
        Map<String, String> map3 = new HashMap<>();

        map.put("path", url);
        map.put("name", "巡检排查标准导入信息");
        mapList.add(map);

        map2.put("path", url2);
        map2.put("name", "填写说明");
        mapList.add(map2);

        map3.put("path", url3);
        map3.put("name", "参考文件-标准分类");
        mapList.add(map3);

        map1.put("path", url1);
        map1.put("name", "参考文件-企业信息");
        mapList.add(map1);

        String fileName = "巡检排查标准批量导入模版.xlsx";
        FileUtil.ExcelUrlToFile(mapList, request, response, fileName);
    }


    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeHazardStandard> createQuery(TSafeHazardStandardParam queryParam) {
        UserInfo loginUser = ContextUtils.getLoginUser();
        QueryWrapper<TSafeHazardStandard> queryWrapper = new QueryWrapper<>();
//        String level = queryParam.getLevel();
        /*if (StringHelper.isNotEmpty(level)) {
            String orgId = loginUser.getOrgId();
            SysOrg one = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq(SysOrg.ORG_ID, orgId));
            String treeLevel = one.getTreeLevel().toString();
            String parentIds = one.getParentIds();

            switch (treeLevel){
                case "1":
                    // 总部登录

                    switch (level){
                        case "1":
                            // 总部标准查询自己
                            queryWrapper.eq(TSafeHazardStandard.ORG_ID,orgId);
                            break;
                        case "2":
                            // 区域公司标准
                            List<SysOrg> orgListByParentId = sysOrgService.getOrgListByParentId(orgId);
                            List<String> orgIdList = orgListByParentId.stream().map(SysOrg::getOrgId).collect(Collectors.toList());
                            queryWrapper.in(TSafeHazardStandard.ORG_ID,orgIdList);
                            break;
                        default:
                            // 基层单位标准 默认所有
                            *//*orgListByParentId = sysOrgService.getOrgListByParentId(orgId);
                            orgIdList = orgListByParentId.stream().map(SysOrg::getOrgId).collect(Collectors.toList());*//*
                            break;
                    }

                    break;
                case "2":
                    // 区域公司登录
                    switch (level){
                        case "1":
                            // 总部标准查询当前登录上级信息
                            queryWrapper.eq(TSafeHazardStandard.ORG_ID,parentIds);
                            break;
                        case "2":
                            // 区域公司标准 查询自己
                            queryWrapper.eq(TSafeHazardStandard.ORG_ID,orgId);
                            break;
                        default:
                            // 基层单位标准 查询当前区域公司下所属粮库
                            List<SysOrg> orgListByParentId = sysOrgService.getOrgListByParentId(parentIds);
                            List<String> orgIdList = orgListByParentId.stream().map(SysOrg::getOrgId).collect(Collectors.toList());
                            queryWrapper.in(TSafeHazardStandard.ORG_ID,orgIdList);
                            break;
                    }
                    break;
                default:
                    // 粮库登录

                    switch (level){
                        case "1":
                            // 总部标准查询当前登录上上级信息
                            String s = one.getParentIds();
                            parentIds = s.split(",")[1];
                            queryWrapper.eq(TSafeHazardStandard.ORG_ID,parentIds);
                            break;
                        case "2":
                            // 区域公司标准查询当前登录上级信息
                            queryWrapper.eq(TSafeHazardStandard.ORG_ID,parentIds);
                            break;
                        default:
                            // 基层单位标准 查询当前区域公司下所属粮库
                            queryWrapper.eq(TSafeHazardStandard.ORG_ID,orgId);
                            break;
                    }
                    break;
            }
        }*/


        if (StringHelper.isNotEmpty(queryParam.getLevel())) {
            String orgId = loginUser.getOrgId();
            SysOrg sysOrg = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq(SysOrg.ORG_ID, orgId));
            int level = Integer.parseInt(queryParam.getLevel());
            String parentIdsString = sysOrg.getParentIds()+","+orgId;
            String[] parentIds = parentIdsString.split(",");
            String parentId = null;
            if (parentIds.length > level) {
                parentId = parentIds[level];
            }
            if (StringHelper.isNotEmpty(parentId)) {
                queryWrapper.eq("org_id", parentId);
            }else {
                List<SysOrg> sysOrgs = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.TREE_LEVEL, level).like(SysOrg.PARENT_IDS, orgId));
                List<String> ids = new ArrayList<>();
                for (SysOrg org : sysOrgs) {
                    ids.add(org.getOrgId());
                }
                if (!ids.isEmpty()) {
                    queryWrapper.in(TSafeHazardStandard.ORG_ID, ids);
                } else {
                    // 处理 ids 列表为空的情况
                    queryWrapper.isNull(TSafeHazardStandard.ORG_ID);
                }
            }

        }

            /*if ("1".equals(level)) {
                if ("1".equals(treeLevel)) {
                    queryWrapper.eq(TSafeHazardStandard.ORG_ID, one.getOrgId());
                }
                if ("2".equals(treeLevel)) {
                    String s = one.getParentIds().split(",")[1];
                    queryWrapper.eq(TSafeHazardStandard.ORG_ID, s);
                }
                if ("3".equals(treeLevel)) {
                    String s = one.getParentIds().split(",")[1];
                    queryWrapper.eq(TSafeHazardStandard.ORG_ID, s);
                }
            }
            if ("2".equals(level)) {
                if ("1".equals(treeLevel)) {
                    List<SysOrg> list = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.TREE_LEVEL, "2"));
                    List<String> strings = new ArrayList<>();
                    for (SysOrg org : list) {
                        strings.add(org.getOrgId());
                    }
                    queryWrapper.in(TSafeHazardStandard.ORG_ID, strings);
                }
                if ("2".equals(treeLevel)) {
                    queryWrapper.eq(TSafeHazardStandard.ORG_ID, one.getOrgId());
                }
                if ("3".equals(treeLevel)) {
                    String s = one.getParentIds().split(",")[2];
                    queryWrapper.eq(TSafeHazardStandard.ORG_ID, s);
                }
            }
            if ("3".equals(level)) {
                if ("1".equals(treeLevel)) {
                    List<SysOrg> list = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.TREE_LEVEL, "3"));
                    List<String> strings = new ArrayList<>();
                    for (SysOrg org : list) {
                        strings.add(org.getOrgId());
                    }
                    queryWrapper.in(TSafeHazardStandard.ORG_ID, strings);
                }
                if ("2".equals(treeLevel)) {
                    List<SysOrg> list = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.PARENT_ID, one.getOrgId()));
                    List<String> strings = new ArrayList<>();
                    for (SysOrg org : list) {
                        strings.add(org.getOrgId());
                    }
                    queryWrapper.in(TSafeHazardStandard.ORG_ID, strings);
                }
                if ("3".equals(treeLevel)) {
                    queryWrapper.eq(TSafeHazardStandard.ORG_ID, one.getOrgId());
                }
            }
        }*/
//        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
//            queryWrapper.eq(TSafeHazardStandard.REF_ID, queryParam.getRefId());
//        }
//        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
//            queryWrapper.eq(TSafeHazardStandard.PARENT_ID, queryParam.getParentId());
//        }
//        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
//            queryWrapper.eq(TSafeHazardStandard.TENANT_ID, queryParam.getTenantId());
//        }
//        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
//            queryWrapper.eq(TSafeHazardStandard.PROCESS_ID, queryParam.getProcessId());
//        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TSafeHazardStandard.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getLevelType())) {
            queryWrapper.eq(TSafeHazardStandard.LEVEL_TYPE, queryParam.getLevelType());
        }
        if (StringHelper.isNotEmpty(queryParam.getStandardType())) {
            queryWrapper.eq(TSafeHazardStandard.STANDARD_TYPE, queryParam.getStandardType());
        }

        if (StringHelper.isNotEmpty(queryParam.getStandardChild())) {
            queryWrapper.like(TSafeHazardStandard.STANDARD_CHILD, queryParam.getStandardChild());
        }

        if (StringHelper.isNotEmpty(queryParam.getStandardName())) {
            queryWrapper.like(TSafeHazardStandard.STANDARD_NAME, queryParam.getStandardName());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.in(TSafeHazardStandard.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStandardStatus())) {
            queryWrapper.eq(TSafeHazardStandard.STANDARD_STATUS, queryParam.getStandardStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeHazardStandard.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeHazardStandard.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TSafeHazardStandard.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
