package com.testor.module.safeCheck.controller;

import cn.hutool.core.util.StrUtil;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckResultDetail;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckResultDetailParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckResultDetailListVO;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckResultDetailVO;
import com.testor.module.safeCheck.service.TSafeHazardCheckResultDetailService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 巡检结果明细(关联标准)Controller
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:56
 */
@RestController
@RequestMapping("/safeCheck/checkResultDetail")
@Api(value = "TSafeHazardCheckResultDetail", tags = "巡检结果明细(关联标准)")
@Slf4j
public class TSafeHazardCheckResultDetailController extends SuperController
{
    @Autowired
    private TSafeHazardCheckResultDetailService tSafeHazardCheckResultDetailService;

//    /* Generated Method*/
//	@ApiOperation(value = "新增 巡检结果明细(关联标准)", notes = "Add TSafeHazardCheckResultDetail")
//	@PostMapping(value = "/add")
//	public BaseResponse<TSafeHazardCheckResultDetail>addEntity(@RequestBody TSafeHazardCheckResultDetail addRequest) {
//		BaseResponse<TSafeHazardCheckResultDetail> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(addRequest)){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//			String id = IdHelper.getId32bit();
//            TSafeHazardCheckResultDetail data=BeanHelper.beanToBean(addRequest,  TSafeHazardCheckResultDetail.class);
//			data.setId(id);
//			boolean result= tSafeHazardCheckResultDetailService.save(data);
//			if(result){
//                TSafeHazardCheckResultDetail newEntity = new TSafeHazardCheckResultDetail();
//				newEntity.setId(id);
//				baseResponse.setData(newEntity);
//			}
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "获取 巡检结果明细(关联标准) ", notes = "Get TSafeHazardCheckResultDetail By Id")
//	@GetMapping(value = "/get")
//	public BaseResponse<TSafeHazardCheckResultDetail> getById(String id){
//		BaseResponse<TSafeHazardCheckResultDetail> baseResponse=new BaseResponse<>();
//		if(StringHelper.isNotEmpty(id)){
//			// TODO 按需求添加业务异常判断
//            TSafeHazardCheckResultDetail data= tSafeHazardCheckResultDetailService.getById(id);
//			baseResponse.setData(data);
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "修改 巡检结果明细(关联标准) ", notes = "Update TSafeHazardCheckResultDetail By Id")
//	@PutMapping(value = "/update")
//	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeHazardCheckResultDetail updateRequest){
//		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//            TSafeHazardCheckResultDetail data=BeanHelper.beanToBean(updateRequest, TSafeHazardCheckResultDetail.class);
//			boolean result= tSafeHazardCheckResultDetailService.updateById(data);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "删除 巡检结果明细(关联标准) ", notes = "delete TSafeHazardCheckResultDetail By Id")
//	@PutMapping(value = "/delete")
//	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardCheckResultDetailDelParam deleteRequest){
//		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
//		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
//			// TODO 按需求添加数据去重，特殊值设定，业务异常
//            TSafeHazardCheckResultDetail data= new TSafeHazardCheckResultDetail();
//			data.setId(deleteRequest.getId());
//			data.setStatus(BizConstants.STATUS_DELETE);
//			boolean result= tSafeHazardCheckResultDetailService.updateById(data);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "批量删除巡检结果明细(关联标准)", notes = "delete TSafeHazardCheckResultDetail by batch Id")
//	@PutMapping(value = "/batch_delete")
//	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
//			@RequestBody TSafeHazardCheckResultDetailDelParam deleteRequest) {
//		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
//		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
//            /* 批量删除 */
//			List<TSafeHazardCheckResultDetail> tSafeHazardCheckResultDetailList = new ArrayList<>();
//            for(String id: deleteRequest.getIds()){
//                TSafeHazardCheckResultDetail data= new TSafeHazardCheckResultDetail();
//				data.setId(id);
//				data.setStatus(BizConstants.STATUS_DELETE);
//                tSafeHazardCheckResultDetailList.add(data);
//			}
//			boolean result = tSafeHazardCheckResultDetailService.updateBatchById(tSafeHazardCheckResultDetailList);
//			baseResponse.setData(
//					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
//		}
//		return baseResponse;
//	}
//
//	@ApiOperation(value = "获取 巡检结果明细(关联标准) 分页列表", notes = "List TSafeHazardCheckResultDetail with page")
//	@GetMapping(value = "/list")
//	public  BaseResponse<BaseResponseList<TSafeHazardCheckResultDetail>>listEntity(TSafeHazardCheckResultDetailParam param){
//		BaseResponse<BaseResponseList<TSafeHazardCheckResultDetail>>baseResponse=new BaseResponse<>();
//		Long page=
//				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
//		Long limit=
//				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
//		Page<TSafeHazardCheckResultDetail> resultPage=new Page<>(page,limit);
//		// TODO 根据需求修改查询条件及查询参数
//		QueryWrapper<TSafeHazardCheckResultDetail> queryWrapper=this.createQuery(param);
//		Page<TSafeHazardCheckResultDetail> resultList= tSafeHazardCheckResultDetailService.page(resultPage,queryWrapper);
//		BaseResponseList<TSafeHazardCheckResultDetail> baseResponseList=new BaseResponseList<>();
//		baseResponseList.setData(resultList.getRecords());
//		baseResponseList.setTotal(resultList.getTotal());
//		baseResponse.setData(baseResponseList);
//		return baseResponse;
//	}

	@ApiOperation(value = "获取 巡检结果明细(关联标准) 列表", notes = "List TSafeHazardCheckResultDetail all")
	@PostMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSafeHazardCheckResultDetail>>listAllEntity(@RequestBody TSafeHazardCheckResultDetailParam param){
		BaseResponse<BaseResponseList<TSafeHazardCheckResultDetail>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		List<TSafeHazardCheckResultDetail> resultList=tSafeHazardCheckResultDetailService.listAllEntity(param);
		BaseResponseList<TSafeHazardCheckResultDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "根据 巡检结果 获取 巡检结果明细列表", notes = "List TSafeHazardCheckResultDetail all")
	@GetMapping(value = "/listByResult")
	public  BaseResponse<BaseResponseList<SafeHazardCheckResultDetailVO>>listAllEntity(String checkResultId){
		BaseResponse<BaseResponseList<SafeHazardCheckResultDetailVO>>baseResponse=new BaseResponse<>();
		BaseResponseList<SafeHazardCheckResultDetailVO> baseResponseList=new BaseResponseList<>();
		if(StrUtil.isBlank(checkResultId)) {
			baseResponseList.setData(null);
			baseResponseList.setTotal(0);
			baseResponse.setData(baseResponseList);
			return baseResponse;
		}

		List<SafeHazardCheckResultDetailVO> resultList=tSafeHazardCheckResultDetailService.listByResult(checkResultId);
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "修改 巡检结果明细的结果值 ", notes = "修改巡检结果 值 \n  需要传id、result_type_id两个值 \n 当有 隐患上报时 需要 relationId(隐患id)")
	@PostMapping(value = "/updateResult")
	public BaseResponse updateEntity(@RequestBody TSafeHazardCheckResultDetail updateRequest){
		BaseResponse baseResponse = tSafeHazardCheckResultDetailService.updateResultDetail(updateRequest);
		return baseResponse;
	}

	@ApiOperation(value = "修改 巡检结果明细的结果值(数组) ", notes = "修改巡检结果 值 \n  需要传id、result_type_id两个值 \n 当有 隐患上报时 需要 relationId(隐患id)")
	@PostMapping(value = "/updateResultList")
	public BaseResponse updateList(@RequestBody SafeHazardCheckResultDetailListVO detailList){

		BaseResponse baseResponse = tSafeHazardCheckResultDetailService.updateResultDetailList(detailList.getUpdateRequestList());
		return baseResponse;
	}


}
