package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 安全检查任务延期记录对象 t_safe_check_task_postpone
 * 
 * @author testor-framework
 * @date 2024-09-05 12:16:55
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_task_postpone")
@ApiModel(value = "TSafeCheckTaskPostpone对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckTaskPostpone extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 任务id
 */
  @ApiModelProperty(value = "任务id")

  @TableField("task_id")
  private String taskId;


  /**
   * 原日期
   */
  @ApiModelProperty(value = "原日期")

  @TableField("original_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date originalDate;

/**
 * 延期日期
 */
  @ApiModelProperty(value = "延期日期")

  @TableField("extension_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date extensionDate;
/**
 * 延期原因
 */
  @ApiModelProperty(value = "延期原因")

  @TableField("cause")
  private String cause;

  @TableField(exist = false)
  private String createByName;

  public static final String ID ="id";
  public static final String TASK_ID ="task_id";
  public static final String EXTENSION_DATE ="extension_date";
  public static final String CAUSE ="cause";


}
