package com.testor.module.section.controller;

import com.testor.module.section.model.dto.TaskInfoDTO;
import com.testor.module.section.model.entity.TSysUploadTask;
import com.testor.module.section.model.param.InitTaskParam;
import com.testor.module.section.service.SysUploadTaskService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.HashMap;
import java.util.Map;

/**
 * 分片上传-分片任务记录(SysUploadTask)表控制层
 *
 * @since 2022-08-22 17:47:31
 */
@RestController
@RequestMapping("/v1/minio/tasks")
public class MinioUploadTaskController {
    /**
     * 服务对象
     */
    @Resource
    private SysUploadTaskService sysUploadTaskService;


    /**
     * 获取上传进度
     * @param identifier 文件md5
     * @return
     */
    @GetMapping("/{identifier}")
    public BaseResponse<TaskInfoDTO> taskInfo (@PathVariable("identifier") String identifier) {
        BaseResponse<TaskInfoDTO> baseResponse = new BaseResponse<>();
        baseResponse.setData(sysUploadTaskService.getTaskInfo(identifier));
        return baseResponse;
    }

    /**
     * 创建一个上传任务
     * @return
     */
    @PostMapping
    public BaseResponse<TaskInfoDTO> initTask (@Valid @RequestBody InitTaskParam param, BindingResult bindingResult) throws BusinessException {
        BaseResponse<TaskInfoDTO> baseResponse = new BaseResponse<>();
        if (bindingResult.hasErrors()) {
            baseResponse.setMsg(bindingResult.getFieldError().getDefaultMessage());
            return baseResponse;
        }
        TaskInfoDTO taskInfoDTO = sysUploadTaskService.initTask(param);
        baseResponse.setCode(200);
        baseResponse.setData(taskInfoDTO);
        return baseResponse;
    }

    /**
     * 获取每个分片的预签名上传地址
     * @param identifier
     * @param partNumber
     * @return
     */
    @GetMapping("/{identifier}/{partNumber}")
    public BaseResponse<String> preSignUploadUrl (@PathVariable("identifier") String identifier, @PathVariable("partNumber") Integer partNumber) {
        BaseResponse<String> baseResponse = new BaseResponse<>();
        TSysUploadTask task = sysUploadTaskService.getByIdentifier(identifier);
        if (task == null) {
            baseResponse.setCode(BaseStatusEnum.UNKNOWN.code());
            return baseResponse;
        }
        Map<String, String> params = new HashMap<>();
        params.put("partNumber", partNumber.toString());
        params.put("uploadId", task.getUploadId());
        baseResponse.setData(sysUploadTaskService.genPreSignUploadUrl(task.getBucketName(), task.getObjectKey(), params));
        return baseResponse;
    }

    /**
     * 合并分片
     * @param identifier
     * @return
     */
    @PostMapping("/merge/{identifier}")
    public BaseResponse<String> merge (@PathVariable("identifier") String identifier) {
        sysUploadTaskService.merge(identifier);
        BaseResponse<String> baseResponse = new BaseResponse<>();
        return baseResponse;
    }

}
