package com.testor.module.train.course.service.impl;

import com.testor.module.train.course.dao.TTrainSmallNodeDao;
import com.testor.module.train.course.model.domain.TTrainSmallNode;
import com.testor.module.train.course.service.TTrainSmallNodeService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 课程小节—安全培训教育Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-25 18:10:52
 */
@Service
public class TTrainSmallNodeServiceImpl extends SuperServiceImpl<TTrainSmallNodeDao, TTrainSmallNode> implements TTrainSmallNodeService {
    @Autowired(required = false)
    private TTrainSmallNodeDao tTrainSmallNodeDao;

    @Override
    public List<TTrainSmallNode> geTreadInformation(List<Object> sectionId, String loginUserId) {
        List<String> sectionIds = (List<String>)(List)sectionId;
        List<TTrainSmallNode> tTrainSmallNodeList = this.baseMapper.getTreadInformation(sectionIds,loginUserId);
        return tTrainSmallNodeList;
    }

    @Override
    public List<TTrainSmallNode> getExaminationInformation(List<Object> sectionIds, String loginUserId, String managementId) {
        List<TTrainSmallNode> tTrainSmallNodeList = this.baseMapper.getExaminationInformation(sectionIds,loginUserId,managementId);
        return tTrainSmallNodeList;
    }
}
