package com.testor.workflow.form.controller;

import com.testor.workflow.form.model.ZFormDTO;
import com.testor.workflow.form.model.ZModelFormDTO;
import com.testor.workflow.form.service.ZFormService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.flowable.idm.api.User;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags ="创建流程表单")
@Slf4j
@RestController
@RequestMapping(value = "/zlmy/form")
public class ZlmyFormController {

    @Autowired
    ZFormService zformService;

    @ApiOperation(value = "创建form")
    @PostMapping(value = "/createForm")
    public BaseResponse<ModelRepresentation> createForm(@RequestBody ZFormDTO zformDto) {

        BaseResponse<ModelRepresentation> baseResponse = new BaseResponse<>();
        if (zformDto.getFormItemList() == null || zformDto.getFormItemList().size() == 0) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("参数缺失");
            return baseResponse;
        }

        User user1 = new User() {
            @Override
            public String getId() {
                return null;
            }

            @Override
            public void setId(String s) {

            }

            @Override
            public String getFirstName() {
                return null;
            }

            @Override
            public void setFirstName(String s) {

            }

            @Override
            public void setLastName(String s) {

            }

            @Override
            public String getLastName() {
                return null;
            }

            @Override
            public void setDisplayName(String s) {

            }

            @Override
            public String getDisplayName() {
                return null;
            }

            @Override
            public void setEmail(String s) {

            }

            @Override
            public String getEmail() {
                return null;
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public void setPassword(String s) {

            }

            @Override
            public String getTenantId() {
                return null;
            }

            @Override
            public void setTenantId(String s) {

            }

            @Override
            public boolean isPictureSet() {
                return false;
            }
        };
        user1.setId("1");
        zformDto.setUser(user1);
        ModelRepresentation model = zformService.createForm(zformDto);
        baseResponse.setData(model);
        return baseResponse;
    }

    @ApiOperation(value = "form绑定流程节点")
    @PostMapping(value = "/bindModelForm")
    public BaseResponse<BizGeneralResponse> bindModelForm(@RequestBody ZModelFormDTO zmodelFormDto) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        boolean result = zformService.bindModelForm(zmodelFormDto);
        if(result) {
            BizGeneralResponse bizGeneralResponse =
                    BizGeneralResponse.builder().result("绑定成功").build();
            baseResponse.setData(bizGeneralResponse);
        } else {
            BizGeneralResponse bizGeneralResponse =
                    BizGeneralResponse.builder().result("绑定失败").build();
            baseResponse.setData(bizGeneralResponse);
        }
        return baseResponse;
    }
}
