/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.context;

import com.alibaba.fastjson.JSONObject;
import com.tongtech.tfw.backend.common.jwt.JwtHelper;
import com.tongtech.tfw.backend.common.models.jwt.JwtInfos;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);

    public static JwtInfos getJwtInfos(String authorization) {
        JwtInfos jwtInfos = JwtHelper.parseJwtAuth0(authorization, "Token Issuer");
        return jwtInfos;
    }

    public static JwtInfos getJwtInfos() {
        HttpServletRequest request = RequestUtil.getRequest();
        String token = request.getHeader("Authorization");
        JwtInfos jwtInfos = JwtHelper.parseJwtAuth0(token, "Token Issuer");
        return jwtInfos;
    }

    public static UserInfo getLoginUser() {
        JwtInfos jwtInfos = ContextUtils.getJwtInfos();
        UserInfo userInfo = (UserInfo)JSONObject.parseObject((String)jwtInfos.getUserInfo(), UserInfo.class);
        return userInfo;
    }

    public static String getLoginUserId() {
        JwtInfos jwtInfos = ContextUtils.getJwtInfos();
        return jwtInfos.getUserId();
    }
}

