/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.log.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.log.LogEnumCode;
import com.testor.biz.sys.log.model.domain.SysLog;
import com.testor.biz.sys.log.model.dto.SysLogDelParam;
import com.testor.biz.sys.log.model.dto.SysLogParam;
import com.testor.biz.sys.log.service.SysLogService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="SysLog", tags={"SysLog \u65e5\u5fd7\u4fe1\u606f\u8868"})
@RequestMapping(value={"/monitor/log"})
public class SysLogController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysLogController.class);
    @Autowired
    private SysLogService sysLogService;

    @ApiOperation(value="\u5220\u9664 SysLog ", notes="\u5220\u9664 SysLog delete SysLog By Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody SysLogDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            List sysLogArrayList = deleteRequest.getIds().stream().map(sysLogId -> ((SysLog.SysLogBuilder)SysLog.builder().id((String)sysLogId).status("1")).build()).collect(Collectors.toList());
            boolean result = this.sysLogService.updateBatchById(sysLogArrayList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 SysLog-Logging \u5206\u9875\u5217\u8868", notes="List SysLog with page")
    @GetMapping(value={"/logging"})
    public BaseResponse<BaseResponseList<SysLog>> listEntityLogging(SysLogParam param) {
        return this.listEntity(param, new BigDecimal(LogEnumCode.LOGGING.code()));
    }

    @ApiOperation(value="\u83b7\u53d6 SysLog-Operation \u5206\u9875\u5217\u8868", notes="List SysLog with page")
    @GetMapping(value={"/operation"})
    public BaseResponse<BaseResponseList<SysLog>> listEntityOperation(SysLogParam param) {
        return this.listEntity(param, new BigDecimal(LogEnumCode.OPERATION.code()));
    }

    @ApiOperation(value="\u83b7\u53d6 SysLog-Other \u5206\u9875\u5217\u8868", notes="List SysLog with page")
    @GetMapping(value={"/error"})
    public BaseResponse<BaseResponseList<SysLog>> listEntityOther(SysLogParam param) {
        return this.listEntity(param, new BigDecimal(LogEnumCode.OTHER.code()));
    }

    @ApiOperation(value="\u6e05\u7a7a\u767b\u5f55\u65e5\u5fd7 SysLog ", notes="delete SysLog By Id")
    @PutMapping(value={"/logging/clear"})
    public BaseResponse<BizGeneralResponse> deleteLogging(@RequestBody SysLogDelParam deleteRequest) {
        return this.emptyEntity(deleteRequest, new BigDecimal(LogEnumCode.LOGGING.code()));
    }

    @ApiOperation(value="\u6e05\u7a7a\u64cd\u4f5c\u65e5\u5fd7 SysLog ", notes="delete SysLog By Id")
    @PutMapping(value={"/option/clear"})
    public BaseResponse<BizGeneralResponse> deleteOption(@RequestBody SysLogDelParam deleteRequest) {
        return this.emptyEntity(deleteRequest, new BigDecimal(LogEnumCode.OPERATION.code()));
    }

    @ApiOperation(value="\u6e05\u7a7a\u5f02\u5e38\u65e5\u5fd7 SysLog ", notes="delete SysLog By Id")
    @PutMapping(value={"/error/clear"})
    public BaseResponse<BizGeneralResponse> deleteError(@RequestBody SysLogDelParam deleteRequest) {
        return this.emptyEntity(deleteRequest, new BigDecimal(LogEnumCode.OTHER.code()));
    }

    private BaseResponse<BizGeneralResponse> emptyEntity(SysLogDelParam param, BigDecimal type) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectHelper.isNotEmpty((Object)param.getStartTime()) && ObjectHelper.isNotEmpty((Object)param.getEndTime())) {
            queryWrapper.between((Object)"op_time", (Object)param.getStartTime(), (Object)param.getEndTime());
        } else if (ObjectHelper.isNotEmpty((Object)param.getStartTime())) {
            queryWrapper.ge((Object)"op_time", (Object)param.getStartTime());
        } else if (ObjectHelper.isNotEmpty((Object)param.getEndTime())) {
            queryWrapper.le((Object)"op_time", (Object)param.getEndTime());
        }
        if (ObjectHelper.isNotEmpty((Object)type)) {
            queryWrapper.eq((Object)"type", (Object)type);
        }
        queryWrapper.ne((Object)"status", (Object)"1");
        List resultList = this.sysLogService.list((Wrapper)queryWrapper);
        for (SysLog sysLog : resultList) {
            sysLog.setStatus("1");
        }
        boolean result = this.sysLogService.updateBatchById(resultList);
        baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        return baseResponse;
    }

    private BaseResponse<BaseResponseList<SysLog>> listEntity(SysLogParam param, BigDecimal type) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        param.setType(type);
        QueryWrapper<SysLog> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.sysLogService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysLog> createQuery(SysLogParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectHelper.isNotEmpty((Object)queryParam.getType())) {
            queryWrapper.eq((Object)"type", (Object)queryParam.getType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getActions())) {
            queryWrapper.like((Object)"actions", (Object)queryParam.getActions());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getUser())) {
            queryWrapper.like((Object)"user", (Object)queryParam.getUser());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getOpTimeStart()) && ObjectHelper.isNotEmpty((Object)queryParam.getOpTimeEnd())) {
            queryWrapper.between((Object)"op_time", (Object)queryParam.getOpTimeStart(), (Object)queryParam.getOpTimeEnd());
        } else if (ObjectHelper.isNotEmpty((Object)queryParam.getOpTimeStart())) {
            queryWrapper.ge((Object)"op_time", (Object)queryParam.getOpTimeStart());
        } else if (ObjectHelper.isNotEmpty((Object)queryParam.getOpTimeEnd())) {
            queryWrapper.le((Object)"op_time", (Object)queryParam.getOpTimeEnd());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

