/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.instance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.apis.instance.model.domain.ActHiProcinst;
import com.tongtech.tfw.workflow.apis.instance.model.dto.ProcessInsListRequest;
import com.tongtech.tfw.workflow.apis.instance.model.dto.ProcessInsListResponse;
import com.tongtech.tfw.workflow.apis.instance.model.dto.ProcessInsOpRequest;
import com.tongtech.tfw.workflow.apis.instance.model.dto.ProcessInsVarRequest;
import com.tongtech.tfw.workflow.apis.instance.service.ActHiProcinstService;
import com.tongtech.tfw.workflow.apis.instance.service.ProcessInsService;
import com.tongtech.tfw.workflow.apis.user.service.ActIdUserService;
import com.tongtech.tfw.workflow.service.TfwCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ActivityInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.api.history.HistoricVariableInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Process Instance Controller", tags={"WF\u6d41\u7a0b\u5b9e\u4f8b\u7ba1\u7406"})
@RequestMapping(value={"/wf/process-instance"})
public class ProcessInstanceController {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    private ProcessInsService processInstanceService;
    @Autowired
    private ActHiProcinstService actHiProcinstService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ActIdUserService actIdUserService;
    @Autowired
    private TfwCommonService tfwCommonService;

    @ApiOperation(value="\u8fd0\u884c\u4e2d\u6d41\u7a0b\u5217\u8868", notes="List Process Instance")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<ProcessInsListResponse>> processInsList(ProcessInsListRequest processInsListRequest) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)processInsListRequest.getPage()) ? BizConstants.PAGE : Long.valueOf(processInsListRequest.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)processInsListRequest.getLimit()) ? BizConstants.LIMIT : Long.valueOf(processInsListRequest.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.isNull((Object)"END_TIME_");
        if (StringHelper.isNotBlank((CharSequence)processInsListRequest.getInstanceId())) {
            queryWrapper.eq((Object)"PROC_INST_ID_", (Object)processInsListRequest.getInstanceId());
        }
        if (StringHelper.isNotBlank((CharSequence)processInsListRequest.getProcessDefinitionName())) {
            queryWrapper.in((Object)"PROC_DEF_ID_", this.tfwCommonService.queryDefId(processInsListRequest.getProcessDefinitionName()));
        }
        if (StringHelper.isNotBlank((CharSequence)processInsListRequest.getStartUser())) {
            queryWrapper.in((Object)"START_USER_ID_", this.tfwCommonService.queryUserIds(processInsListRequest.getStartUser()));
        }
        queryWrapper.orderByDesc((Object)"START_TIME_");
        Page resultList = (Page)this.actHiProcinstService.page((IPage)resultPage, (Wrapper)queryWrapper);
        ArrayList<ProcessInsListResponse> result = new ArrayList<ProcessInsListResponse>(resultList.getRecords().size());
        for (ActHiProcinst actHiProcinst : resultList.getRecords()) {
            ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(actHiProcinst.getProcInstId()).singleResult();
            if (!ObjectHelper.isNotEmpty((Object)process)) continue;
            ProcessInsListResponse processInsListResponse = new ProcessInsListResponse(process);
            processInsListResponse.setStartUser(this.tfwCommonService.queryUserName(processInsListResponse.getStartUser()));
            processInsListResponse.setProcessDefinitionName(this.tfwCommonService.queryDefName(processInsListResponse.getProcessDefinitionId()));
            List actList = ((ActivityInstanceQuery)this.runtimeService.createActivityInstanceQuery().processInstanceId(actHiProcinst.getProcInstId()).activityType("userTask").orderByActivityInstanceStartTime().desc()).list();
            if (!actList.isEmpty()) {
                ActivityInstance activityInstance = (ActivityInstance)actList.get(0);
                processInsListResponse.setCurrentTaskName(activityInstance.getActivityName());
                if (StringHelper.isNotBlank((CharSequence)activityInstance.getAssignee())) {
                    processInsListResponse.setAssigneeName(this.tfwCommonService.queryUserName(activityInstance.getAssignee()));
                }
            }
            result.add(processInsListResponse);
        }
        BaseResponseList responseListBaseResponse = new BaseResponseList();
        responseListBaseResponse.setData(result);
        responseListBaseResponse.setTotal((long)result.size());
        baseResponse.setData((Object)responseListBaseResponse);
        return baseResponse;
    }

    @ApiOperation(value="\u8fd0\u884c\u4e2d\u6d41\u7a0b-\u6302\u8d77", notes="Suspend Process Instance")
    @PutMapping(value={"/suspend"})
    public BaseResponse<BizGeneralResponse> processInsSuspend(@RequestBody @Valid ProcessInsOpRequest suspendReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)suspendReq.getProcessInstanceId())) {
            String result = this.processInstanceService.suspendOrActiveProcessInsById(suspendReq.getProcessInstanceId(), 0);
            BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result(result).build();
            baseResponse.setData((Object)bizGeneralResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u8fd0\u884c\u4e2d\u6d41\u7a0b-\u6fc0\u6d3b", notes="Active Process Instance")
    @PutMapping(value={"/active"})
    public BaseResponse<BizGeneralResponse> processInsActive(@RequestBody @Valid ProcessInsOpRequest activeReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)activeReq.getProcessInstanceId())) {
            String result = this.processInstanceService.suspendOrActiveProcessInsById(activeReq.getProcessInstanceId(), 1);
            BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result(result).build();
            baseResponse.setData((Object)bizGeneralResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u8fd0\u884c\u4e2d\u6d41\u7a0b-\u5173\u95ed", notes="Stop Process Instance")
    @PutMapping(value={"/stop"})
    public BaseResponse<BizGeneralResponse> processInsStop(@RequestBody ProcessInsOpRequest processInsOpRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)processInsOpRequest.getProcessInstanceId())) {
            if (StringHelper.isBlank((CharSequence)processInsOpRequest.getReason())) {
                processInsOpRequest.setReason("\u6d41\u7a0b\u5b9e\u4f8b\u5220\u9664");
            }
            String result = this.processInstanceService.stopInsById(processInsOpRequest.getProcessInstanceId(), processInsOpRequest.getReason());
            BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result(result).build();
            baseResponse.setData((Object)bizGeneralResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u8fd0\u884c\u4e2d\u6d41\u7a0b-\u8ffd\u8e2a", notes="Track Process Instance")
    @GetMapping(value={"/track"})
    public void processInsTrack(@Valid ProcessInsOpRequest processInsOpRequest, HttpServletResponse response) {
        if (StringHelper.isNotEmpty((CharSequence)processInsOpRequest.getProcessInstanceId())) {
            try {
                response.setHeader("Content-Type", "image/png");
                byte[] b = this.processInstanceService.processInsTrackById(processInsOpRequest.getProcessInstanceId());
                IOUtils.write((byte[])b, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                log.error("Get Process Definition Img error: " + e);
            }
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b-\u83b7\u53d6\u53c2\u6570", notes="Query Instance Params")
    @GetMapping(value={"/getParamsByInsId"})
    public BaseResponse<Map<String, Object>> processInsVars(ProcessInsVarRequest processInsVarRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)processInsVarRequest) && StringHelper.isNotBlank((CharSequence)processInsVarRequest.getProcessInstanceId())) {
            HistoricVariableInstanceQuery historicVariableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInsVarRequest.getProcessInstanceId());
            if (StringHelper.isNotEmpty((CharSequence)processInsVarRequest.getExecutionId())) {
                historicVariableInstanceQuery.executionId(processInsVarRequest.getExecutionId());
            }
            if (StringHelper.isNotEmpty((CharSequence)processInsVarRequest.getTaskId())) {
                historicVariableInstanceQuery.taskId(processInsVarRequest.getTaskId());
            }
            List hisVarList = historicVariableInstanceQuery.list();
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (HistoricVariableInstance historicVariableInstance : hisVarList) {
                params.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
            }
            if (StringHelper.isNotBlank((CharSequence)processInsVarRequest.getVarName())) {
                HashMap result = new HashMap();
                Object reV = params.get(processInsVarRequest.getVarName());
                if (ObjectHelper.isNotEmpty(reV)) {
                    result.put(processInsVarRequest.getVarName(), reV);
                } else {
                    result.put(processInsVarRequest.getVarName(), "");
                }
                baseResponse.setData(result);
            } else {
                baseResponse.setData(params);
            }
        }
        return baseResponse;
    }
}

