/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.user.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.apis.user.model.domain.ActIdGroup;
import com.tongtech.tfw.workflow.apis.user.model.dto.ActIdGroupParam;
import com.tongtech.tfw.workflow.apis.user.service.ActIdGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/group"})
@Api(value="ActIdGroup", tags={"WF\u7ec4VIEW"})
public class ActIdGroupController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(ActIdGroupController.class);
    @Autowired
    private ActIdGroupService actIdGroupService;

    @ApiOperation(value="\u83b7\u53d6 wf group view ", notes="Get ActIdGroup By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<ActIdGroup> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            ActIdGroup data = (ActIdGroup)this.actIdGroupService.getById((Serializable)((Object)id));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 wf group view \u5206\u9875\u5217\u8868", notes="List ActIdGroup with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<ActIdGroup>> listEntity(ActIdGroupParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<ActIdGroup> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.actIdGroupService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 wf group view \u5217\u8868", notes="List ActIdGroup all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<ActIdGroup>> listAllEntity(ActIdGroupParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<ActIdGroup> queryWrapper = this.createQuery(param);
        List resultList = this.actIdGroupService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<ActIdGroup> createQuery(ActIdGroupParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getId())) {
            queryWrapper.eq((Object)"ID_", (Object)queryParam.getId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRev())) {
            queryWrapper.eq((Object)"REV_", (Object)queryParam.getRev());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getName())) {
            queryWrapper.eq((Object)"NAME_", (Object)queryParam.getName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getType())) {
            queryWrapper.eq((Object)"TYPE_", (Object)queryParam.getType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"TYPE_");
        }
        return queryWrapper;
    }
}

