/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18nManager {
    private static final int LOCALE_CACHE_SIZE = 10;
    private final ResourceBundle bundle;
    private final Locale locale;
    private static final Map<String, Map<Locale, I18nManager>> managers = new Hashtable<String, Map<Locale, I18nManager>>();

    private I18nManager(String moduleName, Locale locale) {
        Locale bundleLocale;
        ResourceBundle bnd;
        block5: {
            String bundleName = moduleName;
            bnd = null;
            try {
                if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                    locale = Locale.ROOT;
                }
                bnd = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (MissingResourceException ex) {
                Locale.setDefault(Locale.ENGLISH);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) break block5;
                try {
                    bnd = ResourceBundle.getBundle(bundleName, locale, cl);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        this.bundle = bnd;
        this.locale = this.bundle != null ? ((bundleLocale = this.bundle.getLocale()).equals(Locale.ROOT) ? Locale.ENGLISH : bundleLocale) : null;
    }

    public String getString(String key) {
        if (key == null) {
            String msg = "key may not have a null value";
            throw new IllegalArgumentException(msg);
        }
        String str = null;
        try {
            if (this.bundle != null) {
                str = this.bundle.getString(key);
            }
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public String getString(String key, Object ... args) {
        String value = this.getString(key);
        if (value == null) {
            value = key;
        }
        MessageFormat mf = new MessageFormat(value);
        mf.setLocale(this.locale);
        return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static final I18nManager getManager(Class<?> clazz) {
        return I18nManager.getManager(clazz.getPackage().getName());
    }

    public static final I18nManager getManager(String moduleName) {
        return I18nManager.getManager(moduleName, Locale.getDefault());
    }

    public static final synchronized I18nManager getManager(String moduleName, Locale locale) {
        I18nManager mgr;
        LinkedHashMap<Locale, I18nManager> map = managers.get(moduleName);
        if (map == null) {
            map = new LinkedHashMap<Locale, I18nManager>(10, 1.0f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Locale, I18nManager> eldest) {
                    return this.size() > 9;
                }
            };
            managers.put(moduleName, (Map<Locale, I18nManager>)map);
        }
        if ((mgr = map.get(locale)) == null) {
            mgr = new I18nManager(moduleName, locale);
            map.put(locale, mgr);
        }
        return mgr;
    }

    public static I18nManager getManager(String moduleName, Enumeration<Locale> requestedLocales) {
        while (requestedLocales.hasMoreElements()) {
            Locale locale = requestedLocales.nextElement();
            I18nManager result = I18nManager.getManager(moduleName, locale);
            if (!result.getLocale().equals(locale)) continue;
            return result;
        }
        return I18nManager.getManager(moduleName);
    }
}

