/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.el.parser;

import com.tongweb.el.ValueExpressionImpl;
import com.tongweb.el.lang.EvaluationContext;
import com.tongweb.el.lang.LambdaExpressionNestedState;
import com.tongweb.el.parser.AstLambdaParameters;
import com.tongweb.el.parser.AstMethodParameters;
import com.tongweb.el.parser.Node;
import com.tongweb.el.parser.SimpleNode;
import com.tongweb.el.util.MessageFactory;
import java.util.ArrayList;
import javax.el.ELException;
import javax.el.LambdaExpression;

public class AstLambdaExpression
extends SimpleNode {
    public AstLambdaExpression(int id) {
        super(id);
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        int methodParameterSetCount;
        LambdaExpressionNestedState state = ctx.getLambdaExpressionNestedState();
        if (state == null) {
            state = new LambdaExpressionNestedState();
            this.populateNestedState(state);
            ctx.setLambdaExpressionNestedState(state);
        }
        if ((methodParameterSetCount = this.jjtGetNumChildren() - 2) > state.getNestingCount()) {
            throw new ELException(MessageFactory.get("error.lambda.tooManyMethodParameterSets"));
        }
        AstLambdaParameters formalParametersNode = (AstLambdaParameters)this.children[0];
        SimpleNode[] formalParamNodes = formalParametersNode.children;
        ValueExpressionImpl ve = new ValueExpressionImpl("", this.children[1], ctx.getFunctionMapper(), ctx.getVariableMapper(), null);
        ArrayList<String> formalParameters = new ArrayList<String>();
        if (formalParamNodes != null) {
            for (SimpleNode formalParamNode : formalParamNodes) {
                formalParameters.add(formalParamNode.getImage());
            }
        }
        LambdaExpression le = new LambdaExpression(formalParameters, ve);
        le.setELContext(ctx);
        if (this.jjtGetNumChildren() == 2) {
            if (state.getHasFormalParameters()) {
                return le;
            }
            return le.invoke(ctx, (Object[])null);
        }
        int methodParameterIndex = 2;
        Object result = le.invoke(((AstMethodParameters)this.children[methodParameterIndex]).getParameters(ctx));
        ++methodParameterIndex;
        while (result instanceof LambdaExpression && methodParameterIndex < this.jjtGetNumChildren()) {
            result = ((LambdaExpression)result).invoke(((AstMethodParameters)this.children[methodParameterIndex]).getParameters(ctx));
            ++methodParameterIndex;
        }
        return result;
    }

    private void populateNestedState(LambdaExpressionNestedState lambdaExpressionNestedState) {
        lambdaExpressionNestedState.incrementNestingCount();
        if (this.jjtGetNumChildren() > 1) {
            Node firstChild = this.jjtGetChild(0);
            if (firstChild instanceof AstLambdaParameters) {
                if (firstChild.jjtGetNumChildren() > 0) {
                    lambdaExpressionNestedState.setHasFormalParameters();
                }
            } else {
                return;
            }
            Node secondChild = this.jjtGetChild(1);
            if (secondChild instanceof AstLambdaExpression) {
                ((AstLambdaExpression)secondChild).populateNestedState(lambdaExpressionNestedState);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (SimpleNode n : this.children) {
            result.append(((Object)n).toString());
        }
        return result.toString();
    }
}

