/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.bean;

import com.tongtech.tfw.backend.core.helper.ClassHelper;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.springframework.cglib.beans.BeanMap;

public class BeanHelper {
    private static final ModelMapper MODEL_MAPPER = new ModelMapper();

    public static ModelMapper getModelMapper() {
        return MODEL_MAPPER;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        return BeanHelper.beanToMap(bean, true);
    }

    public static <T> Map<String, Object> beanToMap(T bean, boolean includeNull) {
        Map<String, Object> map = Collections.emptyMap();
        if (null != bean) {
            BeanMap beanMap = BeanMap.create(bean);
            map = new HashMap<String, Object>(beanMap.keySet().size());
            for (Object key : beanMap.keySet()) {
                if (Objects.nonNull(beanMap.get(key))) {
                    map.put(String.valueOf(key), beanMap.get(key));
                    continue;
                }
                if (!includeNull) continue;
                map.put(String.valueOf(key), beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> Map<String, String> beanToStringMap(T bean) {
        Map<String, String> map = Collections.emptyMap();
        if (null != bean) {
            BeanMap beanMap = BeanMap.create(bean);
            map = new HashMap<String, String>(beanMap.keySet().size());
            for (Object key : beanMap.keySet()) {
                if (!Objects.nonNull(beanMap.get(key))) continue;
                map.put(String.valueOf(key), TypeHelper.castToString(beanMap.get(key)));
            }
        }
        return map;
    }

    public static <T> List<Map<String, Object>> beansToMaps(List<T> beanList) {
        List<Map<String, Object>> mapList = Collections.emptyList();
        if (CollectionHelper.isNotEmpty(beanList)) {
            mapList = new ArrayList<Map<String, Object>>(beanList.size());
            Iterator<T> iterator = beanList.iterator();
            while (iterator.hasNext()) {
                T anObjList;
                T bean = anObjList = iterator.next();
                Map<String, Object> map = BeanHelper.beanToMap(bean);
                mapList.add(map);
            }
        }
        return mapList;
    }

    public static <T> List<T> mapsToBeans(List<Map<String, Object>> mapList, Class<T> beanClass) {
        List beanList = Collections.emptyList();
        if (CollectionHelper.isNotEmpty(mapList)) {
            beanList = new ArrayList(mapList.size());
            Iterator<Map<String, Object>> iterator = mapList.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> map1;
                Map<String, Object> map = map1 = iterator.next();
                T bean = BeanHelper.mapToBean(map, beanClass);
                beanList.add(bean);
            }
        }
        return beanList;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        T bean = ClassHelper.newInstance(beanClass);
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<T> listToList(List<?> sourceList, Class<T> targetClass) {
        return CollectionHelper.isEmpty(sourceList) ? Collections.emptyList() : sourceList.stream().map(source -> BeanHelper.beanToBean(source, targetClass)).collect(Collectors.toList());
    }

    public static <T> T beanToBean(Object source, Class<T> targetClass) {
        return (T)BeanHelper.getModelMapper().map(source, targetClass);
    }

    static {
        MODEL_MAPPER.getConfiguration().setFullTypeMatchingRequired(true);
        MODEL_MAPPER.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
    }
}

