/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.properties;

import com.tongtech.commons.license.DefaultHandler;
import com.tongtech.commons.license.LicenseSDKProvider;
import com.tongtech.commons.license.b.a;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http11.Http11Nio2Protocol;
import com.tongweb.connector.http11.Http11NioProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Valve;
import com.tongweb.container.audit.AuditLog;
import com.tongweb.container.core.StandardHost;
import com.tongweb.container.security.SecurityListener;
import com.tongweb.container.valves.AbstractAccessLogValve;
import com.tongweb.container.valves.AccessLogValve;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.container.valves.ExtendedAccessLogValve;
import com.tongweb.container.valves.JsonErrorReportValve;
import com.tongweb.container.valves.RemoteIpValve;
import com.tongweb.container.valves.SemaphoreValve;
import com.tongweb.container.valves.StuckThreadDetectionValve;
import com.tongweb.springboot.properties.IoMode;
import com.tongweb.springboot.properties.PropertyMapper;
import com.tongweb.springboot.properties.RemoteFilter;
import com.tongweb.springboot.properties.RemoteFilterConfigBean;
import com.tongweb.springboot.properties.SocketConfigBean;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.properties.TongwebConfig;
import com.tongweb.springboot.spring.DataSize;
import com.tongweb.springboot.starter.TongWebServletWebServerFactory;
import com.tongweb.web.util.http.CookieProcessor;
import com.tongweb.web.util.http.LegacyCookieProcessor;
import com.tongweb.web.util.net.DOSFilter;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class TongWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<TongWebServletWebServerFactory>,
Ordered {
    private static final Log logger = LogFactory.getLog(TongWebServerFactoryCustomizer.class);
    private final Environment environment;
    private final TongWebProperties serverProperties;

    public TongWebServerFactoryCustomizer(Environment environment, TongWebProperties tongWebProperties) {
        this.environment = environment;
        this.serverProperties = tongWebProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(TongWebServletWebServerFactory factory) {
        this.customizeOptimize();
        TongWebProperties properties = this.serverProperties;
        TongwebConfig tongweb = properties.getTongweb();
        Boolean sendReasonPhrase = tongweb.getSendReasonPhrase();
        System.setProperty("tongweb.send.reason.phrase", String.valueOf(sendReasonPhrase));
        this.customizeSlowHTTPParameter(tongweb);
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(tongweb::getNotAllowHttpMethods).to(factory::setNotAllowHttpMethods);
        propertyMapper.from(tongweb::getIoMode).whenNonNull().as(IoMode::getClassName).to(factory::setProtocol);
        propertyMapper.from(tongweb::getBasedir).whenNonNull().to(factory::setBaseDirectory);
        propertyMapper.from(tongweb::getBackgroundProcessorDelay).whenNonNull().as(Duration::getSeconds).as(Long::intValue).to(factory::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory);
        propertyMapper.from(tongweb::getMaxThreads).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory, tongweb.getMaxThreads()));
        propertyMapper.from(tongweb::getMinSpareThreads).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory, (int)minSpareThreads));
        propertyMapper.from(this.serverProperties.getMaxHttpHeaderSize()).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(this.serverProperties.getTongweb().getMaxSavePostSize()).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).when(this::isPositive).to(maxSavePostSize -> this.customizeMaxSavePostSize(factory, (int)maxSavePostSize));
        propertyMapper.from(tongweb::getMaxSwallowSize).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).to(maxSwallowSize -> this.customizeMaxSwallowSize(factory, (int)maxSwallowSize));
        propertyMapper.from(tongweb::getMaxHttpPostSize).as(DataSize::parse).asInt(DataSize::toBytes).when(maxHttpPostSize -> maxHttpPostSize != 0).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(factory, (int)maxHttpPostSize));
        propertyMapper.from(tongweb::getMaxParameterCount).when(maxParameterCount -> maxParameterCount != 0).to(maxParameterCount -> this.customizeMaxParameterCount(factory, (int)maxParameterCount));
        propertyMapper.from(tongweb::getAccesslog).when(TongwebConfig.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory, (TongwebConfig.Accesslog)enabled));
        propertyMapper.from(tongweb::getAuditLog).when(AuditLog::getEnable).to(auditLog -> this.customizeAuditLog(factory, (AuditLog)auditLog));
        propertyMapper.from(tongweb::getRemoteFilter).when(RemoteFilter::isEnabled).to(remoteFilter -> this.customizeRemoteFilter(factory, (RemoteFilter)remoteFilter));
        propertyMapper.from(tongweb.getFilter().getRemote()).when(RemoteFilter::isEnabled).to(remoteFilter -> this.customizeRemoteFilter(factory, (RemoteFilter)remoteFilter));
        propertyMapper.from(tongweb.getDocBasePath()).whenNonNull().to(docBasePath -> this.customizeDocBase(factory, (String)docBasePath));
        propertyMapper.from(tongweb.getWebApp()).whenNonNull().whenNot(Map::isEmpty).to(webApp -> this.customizeWebApps(factory, (Map<String, String>)webApp));
        propertyMapper.from(tongweb::getSemaphore).when(TongwebConfig.SemaphoreConf::isEnabled).to(enabled -> this.customizeSemaphore(factory));
        propertyMapper.from(tongweb::getUriEncoding).whenNonNull().to(factory::setUriEncoding);
        propertyMapper.from(tongweb::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        propertyMapper.from(tongweb::getConnectionLinger).whenNonNull().to(connectionLinger -> this.customizeConnectionLinger(factory, (Duration)connectionLinger));
        propertyMapper.from(tongweb::getConnectionUploadTimeout).when(duration -> tongweb.getDisableUploadTimeout() == false).when(Objects::nonNull).to(connectionUploadTimeout -> this.customizeConnectionUploadTimeout(factory, (Duration)connectionUploadTimeout));
        propertyMapper.from(tongweb::getDisableUploadTimeout).whenNonNull().to(disableUploadTimeout -> this.customizeDisableUploadTimeout(factory, (Boolean)disableUploadTimeout));
        propertyMapper.from(tongweb::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory, (int)maxConnections));
        propertyMapper.from(tongweb::getMaxHeaderCount).to(maxHeaderCount -> this.customizeMaxHeaderCount(factory, (int)maxHeaderCount));
        propertyMapper.from(tongweb::getEnableLookups).to(enableLookups -> this.customizeEnableLookups(factory, (boolean)enableLookups));
        propertyMapper.from(tongweb::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        propertyMapper.from(tongweb::getProcessorCache).to(processorCache -> this.customizeProcessorCache(factory, (int)processorCache));
        propertyMapper.from(tongweb::getKeepAliveTimeout).whenNonNull().to(keepAliveTimeout -> this.customizeKeepAliveTimeout(factory, (Duration)keepAliveTimeout));
        propertyMapper.from(tongweb::getStuckThreadDetection).whenNonNull().to(stuckThreadDetection -> this.customizeStuckThreadDetectionValue(factory, (TongwebConfig.StuckThreadDetectionConf)stuckThreadDetection));
        propertyMapper.from(tongweb::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        propertyMapper.from(tongweb::getMaxExtensionSize).whenNonNull().to(maxExtensionSize -> this.customizeMaxExtensionSize(factory, (int)maxExtensionSize));
        propertyMapper.from(tongweb::getAsyncTimeout).whenNonNull().to(asyncTimeout -> this.customizeAsyncTimeout(factory, (Duration)asyncTimeout));
        propertyMapper.from(tongweb::getDiscardFacades).whenNonNull().to(discardFacades -> this.customizeDiscardFacades(factory, (Boolean)discardFacades));
        propertyMapper.from(tongweb::getEncodedSolidusHandling).whenNonNull().to(encodedSolidusHandling -> this.customizeEncodedSolidusHandling(factory, (String)encodedSolidusHandling));
        propertyMapper.from(tongweb::getMaxCookieCount).whenNonNull().to(maxCookieCount -> this.customizeMaxCookieCount(factory, (Integer)maxCookieCount));
        propertyMapper.from(tongweb::getMaxTrailerSize).whenNonNull().to(maxTrailerSize -> this.customizeMaxTrailerSize(factory, (Integer)maxTrailerSize));
        propertyMapper.from(tongweb::getRejectIllegalHeader).whenNonNull().to(rejectIllegalHeader -> this.customizeRejectIllegalHeader(factory, (Boolean)rejectIllegalHeader));
        propertyMapper.from(tongweb::getRestrictedUserAgents).whenNonNull().to(restrictedUserAgents -> this.customizeRestrictedUserAgents(factory, (String)restrictedUserAgents));
        propertyMapper.from(tongweb::getTcpNoDelay).whenNonNull().to(tcpNoDelay -> this.customizeTcpNoDelay(factory, (Boolean)tcpNoDelay));
        propertyMapper.from(tongweb::getThrowOnFailure).whenNonNull().to(throwOnFailure -> this.customizeThrowOnFailure(factory, (Boolean)throwOnFailure));
        propertyMapper.from(tongweb::getUseKeepAliveResponseHeader).whenNonNull().to(useKeepAliveResponseHeader -> this.customizeUseKeepAliveResponseHeader(factory, (Boolean)useKeepAliveResponseHeader));
        propertyMapper.from(tongweb::getSelectorTimeout).whenNonNull().to(selectorTimeout -> this.customizeSelectorTimeout(factory, (Long)selectorTimeout));
        propertyMapper.from(tongweb::getUseSendFile).whenNonNull().to(useSendFile -> this.customizeUseSendFile(factory, (Boolean)useSendFile));
        propertyMapper.from(tongweb::getSocket).to(socket -> this.customizeSocket(factory, (SocketConfigBean)socket));
        propertyMapper.from(tongweb::getRelaxedPathChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedPathChars(factory, (String)relaxedChars));
        propertyMapper.from(tongweb::getRelaxedQueryChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedQueryChars(factory, (String)relaxedChars));
        propertyMapper.from(tongweb::getWar).whenNonNull().to(war -> this.customizeWar(factory, (String)war));
        this.customizeErrorReportValve(factory);
        propertyMapper.from(tongweb::getUseLegacyCookieProcessor).whenTrue().to(x -> this.customizeCookieProcessor(factory));
        this.customizeSecurityListener(factory);
    }

    private void customizeOptimize() {
        String optimize = this.serverProperties.getTongweb().getOptimize();
        optimize = StringUtils.hasLength((String)optimize) ? optimize : "false";
        System.setProperty("optimize", optimize);
        System.setProperty("optimize-static", optimize);
        Boolean jarReadOptimizeEnable = this.serverProperties.getTongweb().getJarReadOptimizeEnable();
        System.setProperty("server.tongweb.jarReadOptimizeEnable", String.valueOf(jarReadOptimizeEnable));
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private void customizeAcceptCount(TongWebServletWebServerFactory factory, int acceptCount) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setAcceptCount(acceptCount);
            }
        });
    }

    private void customizeProcessorCache(TongWebServletWebServerFactory factory, int processorCache) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                ((AbstractProtocol)handler).setProcessorCache(processorCache);
            }
        });
    }

    private void customizeKeepAliveTimeout(TongWebServletWebServerFactory factory, Duration keepAliveTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setKeepAliveTimeout((int)keepAliveTimeout.toMillis());
            }
        });
    }

    private void customizeMaxKeepAliveRequests(TongWebServletWebServerFactory factory, int maxKeepAliveRequests) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxKeepAliveRequests(maxKeepAliveRequests);
            }
        });
    }

    private void customizeMaxExtensionSize(TongWebServletWebServerFactory factory, int maxExtensionSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxExtensionSize(maxExtensionSize);
            }
        });
    }

    private void customizeAsyncTimeout(TongWebServletWebServerFactory factory, Duration asyncTimeout) {
        factory.addConnectorCustomizers(connector -> connector.setAsyncTimeout(asyncTimeout.toMillis()));
    }

    private void customizeDiscardFacades(TongWebServletWebServerFactory factory, Boolean discardFacades) {
        factory.addConnectorCustomizers(connector -> connector.setDiscardFacades(discardFacades.booleanValue()));
    }

    private void customizeEnableLookups(TongWebServletWebServerFactory factory, boolean enableLookups) {
        factory.addConnectorCustomizers(connector -> connector.setEnableLookups(enableLookups));
    }

    private void customizeEncodedSolidusHandling(TongWebServletWebServerFactory factory, String encodedSolidusHandling) {
        factory.addConnectorCustomizers(connector -> connector.setEncodedSolidusHandling(encodedSolidusHandling));
    }

    private void customizeMaxCookieCount(TongWebServletWebServerFactory factory, Integer maxCookieCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxCookieCount(maxCookieCount.intValue()));
    }

    private void customizeCookieProcessor(TongWebServletWebServerFactory factory) {
        factory.addContextCustomizers(context -> context.setCookieProcessor((CookieProcessor)new LegacyCookieProcessor()));
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private void customizeMaxTrailerSize(TongWebServletWebServerFactory factory, Integer maxTrailerSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxTrailerSize(maxTrailerSize.intValue());
            }
        });
    }

    private void customizeRejectIllegalHeader(TongWebServletWebServerFactory factory, Boolean rejectIllegalHeader) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRejectIllegalHeader(rejectIllegalHeader.booleanValue());
            }
        });
    }

    private void customizeRestrictedUserAgents(TongWebServletWebServerFactory factory, String restrictedUserAgents) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setRestrictedUserAgents(restrictedUserAgents);
            }
        });
    }

    private void customizeTcpNoDelay(TongWebServletWebServerFactory factory, Boolean tcpNoDelay) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setTcpNoDelay(tcpNoDelay.booleanValue());
            }
        });
    }

    private void customizeThrowOnFailure(TongWebServletWebServerFactory factory, Boolean throwOnFailure) {
        factory.addConnectorCustomizers(connector -> connector.setThrowOnFailure(throwOnFailure.booleanValue()));
    }

    private void customizeUseKeepAliveResponseHeader(TongWebServletWebServerFactory factory, Boolean useKeepAliveResponseHeader) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setUseKeepAliveResponseHeader(useKeepAliveResponseHeader.booleanValue());
            }
        });
    }

    private void customizeParseBodyMethods(TongWebServletWebServerFactory factory, String parseBodyMethods) {
        factory.addConnectorCustomizers(connector -> connector.setParseBodyMethods(parseBodyMethods));
    }

    private void customizeAcceptorThreadPriority(TongWebServletWebServerFactory factory, Integer acceptorThreadPriority) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setAcceptorThreadPriority(acceptorThreadPriority.intValue());
            }
        });
    }

    private void customizePollerThreadPriority(TongWebServletWebServerFactory factory, Integer pollerThreadPriority) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof Http11NioProtocol) {
                Http11NioProtocol protocol = (Http11NioProtocol)handler;
                protocol.setPollerThreadPriority(pollerThreadPriority.intValue());
            }
        });
    }

    private void customizeSelectorTimeout(TongWebServletWebServerFactory factory, Long selectorTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof Http11NioProtocol) {
                Http11NioProtocol protocol = (Http11NioProtocol)handler;
                protocol.setSelectorTimeout(selectorTimeout.longValue());
            }
        });
    }

    private void customizeUseSendFile(TongWebServletWebServerFactory factory, Boolean useSendFile) {
        factory.addConnectorCustomizers(connector -> {
            Http11NioProtocol protocol;
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof Http11NioProtocol) {
                protocol = (Http11NioProtocol)handler;
                protocol.setUseSendfile(useSendFile.booleanValue());
            }
            if (handler instanceof Http2Protocol) {
                protocol = (Http2Protocol)handler;
                protocol.setUseSendfile(useSendFile.booleanValue());
            }
            if (handler instanceof Http11Nio2Protocol) {
                protocol = (Http11Nio2Protocol)handler;
                protocol.setUseSendfile(useSendFile.booleanValue());
            }
        });
    }

    private void customizeSocket(TongWebServletWebServerFactory factory, SocketConfigBean socket) {
        factory.addConnectorCustomizers(connector -> {
            if (socket.getDirectBuffer() != null) {
                connector.setProperty("socket.directBuffer", socket.getDirectBuffer().toString());
            }
            if (socket.getDirectSslBuffer() != null) {
                connector.setProperty("socket.directSslBuffer", socket.getDirectSslBuffer().toString());
            }
            if (socket.getRxBufSize() != null) {
                connector.setProperty("socket.rxBufSize", socket.getRxBufSize().toString());
            }
            if (socket.getTxBufSize() != null) {
                connector.setProperty("socket.txBufSize", socket.getTxBufSize().toString());
            }
            if (socket.getAppReadBufSize() != null) {
                connector.setProperty("socket.appReadBufSize", socket.getAppReadBufSize().toString());
            }
            if (socket.getAppWriteBufSize() != null) {
                connector.setProperty("socket.appWriteBufSize", socket.getAppWriteBufSize().toString());
            }
            if (socket.getBufferPool() != null) {
                connector.setProperty("socket.bufferPool", socket.getBufferPool().toString());
            }
            if (socket.getBufferPoolSize() != null) {
                connector.setProperty("socket.bufferPoolSize", socket.getBufferPoolSize().toString());
            }
            if (socket.getProcessorCache() != null) {
                connector.setProperty("socket.processorCache", socket.getProcessorCache().toString());
            }
            if (socket.getKeyCache() != null) {
                connector.setProperty("socket.keyCache", socket.getKeyCache().toString());
            }
            if (socket.getEventCache() != null) {
                connector.setProperty("socket.eventCache", socket.getEventCache().toString());
            }
            if (socket.getTcpNoDelay() != null) {
                connector.setProperty("socket.tcpNoDelay", socket.getTcpNoDelay().toString());
            }
            if (socket.getSoKeepAlive() != null) {
                connector.setProperty("socket.soKeepAlive", socket.getSoKeepAlive().toString());
            }
            if (socket.getOoBInline() != null) {
                connector.setProperty("socket.ooBInline", socket.getOoBInline().toString());
            }
            if (socket.getSoReuseAddress() != null) {
                connector.setProperty("socket.soReuseAddress", socket.getSoReuseAddress().toString());
            }
            if (socket.getSoLingerOn() != null) {
                connector.setProperty("socket.soLingerOn", socket.getSoLingerOn().toString());
            }
            if (socket.getSoLingerTime() != null) {
                connector.setProperty("socket.soLingerTime", socket.getSoLingerTime().toString());
            }
            if (socket.getSoTimeout() != null) {
                connector.setProperty("socket.soTimeout", socket.getSoTimeout().toString());
            }
            if (socket.getPerformanceConnectionTime() != null) {
                connector.setProperty("socket.performanceConnectionTime", socket.getPerformanceConnectionTime().toString());
            }
            if (socket.getPerformanceLatency() != null) {
                connector.setProperty("socket.performanceLatency", socket.getPerformanceLatency().toString());
            }
            if (socket.getPerformanceBandwidth() != null) {
                connector.setProperty("socket.performanceBandwidth", socket.getPerformanceBandwidth().toString());
            }
            if (socket.getUnlockTimeout() != null) {
                connector.setProperty("socket.unlockTimeout", socket.getUnlockTimeout().toString());
            }
        });
    }

    private void customizeMaxConnections(TongWebServletWebServerFactory factory, int maxConnections) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxConnections(maxConnections);
            }
        });
    }

    private void customizeMaxHeaderCount(TongWebServletWebServerFactory factory, int maxHeaderCount) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxHeaderCount(maxHeaderCount);
            }
        });
    }

    private void customizeConnectionTimeout(TongWebServletWebServerFactory factory, Duration connectionTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionTimeout((int)connectionTimeout.toMillis());
            }
        });
    }

    private void customizeConnectionLinger(TongWebServletWebServerFactory factory, Duration connectionLinger) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionLinger((int)connectionLinger.toMillis());
            }
        });
    }

    private void customizeConnectionUploadTimeout(TongWebServletWebServerFactory factory, Duration connectionUploadTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setConnectionUploadTimeout((int)connectionUploadTimeout.toMillis());
            }
        });
    }

    private void customizeDisableUploadTimeout(TongWebServletWebServerFactory factory, Boolean disableUploadTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setDisableUploadTimeout(disableUploadTimeout.booleanValue());
            }
        });
    }

    private void customizeRelaxedPathChars(TongWebServletWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setAttribute("relaxedPathChars", (Object)relaxedChars));
    }

    private void customizeRelaxedQueryChars(TongWebServletWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setAttribute("relaxedQueryChars", (Object)relaxedChars));
    }

    private void customizeWar(TongWebServletWebServerFactory factory, String war) {
        factory.setWar(war);
    }

    private void customizeRemoteIpValve(TongWebServletWebServerFactory factory) {
        TongwebConfig tongweb = this.serverProperties.getTongweb();
        String protocolHeader = tongweb.getProtocolHeader();
        String remoteIpHeader = tongweb.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setInternalProxies(tongweb.getInternalProxies());
            valve.setHostHeader(tongweb.getHostHeader());
            valve.setPortHeader(tongweb.getPortHeader());
            valve.setProtocolHeaderHttpsValue(tongweb.getProtocolHeaderHttpsValue());
            factory.addEngineValves(new Valve[]{valve});
        }
    }

    private void customizeStuckThreadDetectionValue(TongWebServletWebServerFactory factory, TongwebConfig.StuckThreadDetectionConf stuckThreadDetection) {
        if (stuckThreadDetection.getThreshold() != 0) {
            StuckThreadDetectionValve value = new StuckThreadDetectionValve();
            value.setThreshold(stuckThreadDetection.getThreshold());
            value.setInterruptThreadThreshold(stuckThreadDetection.getInterruptThreadThreshold());
            factory.addEngineValves(new Valve[]{value});
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)TongWebProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeMaxThreads(TongWebServletWebServerFactory factory, final int maxThreads) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                final AbstractProtocol protocol = (AbstractProtocol)handler;
                int targetThread = LicenseSDKProvider.getLimitThreadsByLicense((int)maxThreads);
                protocol.setMaxThreads(targetThread);
                LicenseSDKProvider.registerLicenseValidListener((a)new DefaultHandler(){

                    public void doSuccess(int code, String message) {
                        super.doSuccess(code, message);
                        if (LicenseSDKProvider.isLimitThreadsByLicense()) {
                            protocol.setMaxThreads(5);
                        } else {
                            int targetThread = LicenseSDKProvider.getLimitThreadsByLicense((int)maxThreads);
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Dynamic loading license file support for number of maxThreads turning. current : " + protocol.getMinSpareThreads() + " change to: " + targetThread));
                            }
                            protocol.setMaxThreads(targetThread);
                        }
                    }
                });
            }
        });
    }

    private void customizeMinThreads(TongWebServletWebServerFactory factory, final int minSpareThreads) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                final AbstractProtocol protocol = (AbstractProtocol)handler;
                int targetThread = LicenseSDKProvider.getLimitThreadsByLicense((int)minSpareThreads);
                protocol.setMinSpareThreads(targetThread);
                LicenseSDKProvider.registerLicenseValidListener((a)new DefaultHandler(){

                    public void doSuccess(int code, String message) {
                        super.doSuccess(code, message);
                        if (LicenseSDKProvider.isLimitThreadsByLicense()) {
                            protocol.setMinSpareThreads(5);
                        } else {
                            int targetThread = LicenseSDKProvider.getLimitThreadsByLicense((int)minSpareThreads);
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("Dynamic loading license file support for number of maxThreads turning. current : " + protocol.getMinSpareThreads() + " change to: " + targetThread));
                            }
                            protocol.setMinSpareThreads(targetThread);
                        }
                    }
                });
            }
        });
    }

    private void customizeMaxHttpHeaderSize(TongWebServletWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        });
    }

    private void customizeMaxSavePostSize(TongWebServletWebServerFactory factory, int maxSavePostSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxSavePostSize(maxSavePostSize);
            }
        });
    }

    private void customizeMaxSwallowSize(TongWebServletWebServerFactory factory, int maxSwallowSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxSwallowSize(maxSwallowSize);
            }
        });
    }

    private void customizeMaxHttpPostSize(TongWebServletWebServerFactory factory, int maxHttpPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpPostSize));
    }

    private void customizeSlowHTTPParameter(TongwebConfig tongweb) {
        int messageTimeOut;
        DOSFilter.completeMessageTimeout = messageTimeOut = tongweb.getMessageTimeout();
        if (messageTimeOut > 0) {
            DOSFilter.attackCheck = true;
            DOSFilter.maxAttackTimes = tongweb.getMaxAttackTimes();
            DOSFilter.blackListExpired = tongweb.getBlacklistExpiredHours();
            DOSFilter.interruptCurrentConnect = tongweb.isInterruptCurrentConnect();
        } else {
            DOSFilter.attackCheck = false;
        }
    }

    private void customizeMaxParameterCount(TongWebServletWebServerFactory factory, int maxParameterCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxParameterCount(maxParameterCount));
    }

    private void customizeSemaphore(TongWebServletWebServerFactory factory) {
        SemaphoreValve valve = new SemaphoreValve();
        TongwebConfig tongweb = this.serverProperties.getTongweb();
        PropertyMapper map = PropertyMapper.get();
        TongwebConfig.SemaphoreConf semaphoreConfig = tongweb.getSemaphore();
        map.from(semaphoreConfig.getConcurrency()).to(arg_0 -> ((SemaphoreValve)valve).setConcurrency(arg_0));
        map.from(semaphoreConfig.isFairness()).to(arg_0 -> ((SemaphoreValve)valve).setFairness(arg_0));
        map.from(semaphoreConfig.isBlock()).to(arg_0 -> ((SemaphoreValve)valve).setBlock(arg_0));
        map.from(semaphoreConfig.isInterruptible()).to(arg_0 -> ((SemaphoreValve)valve).setInterruptible(arg_0));
        factory.setSemaphore((Valve)valve);
    }

    private void customizeAccessLog(TongWebServletWebServerFactory factory, TongwebConfig.Accesslog accessLogConfig) {
        ExtendedAccessLogValve valve;
        TongwebConfig tongweb = this.serverProperties.getTongweb();
        PropertyMapper map = PropertyMapper.get();
        if (accessLogConfig.isLogExtend()) {
            valve = new ExtendedAccessLogValve();
            if (accessLogConfig.getPattern().contains("%") || accessLogConfig.getPattern().equalsIgnoreCase("common")) {
                logger.warn((Object)"If setting server.tongweb.accesslog.log-extend=true, need change pattern to extended mode pattern.");
                logger.warn((Object)"for example:");
                logger.warn((Object)"\tserver.tongweb.accesslog.pattern=date time time-taken cs-method cs-uri sc-status");
            }
        } else {
            valve = new AccessLogValve();
        }
        map.from(accessLogConfig.getConditionIf()).to(arg_0 -> ((AccessLogValve)valve).setConditionIf(arg_0));
        map.from(accessLogConfig.isAsciiToNative()).to(AbstractAccessLogValve::setAsciiToNative);
        map.from(accessLogConfig.getConditionUnless()).to(arg_0 -> ((AccessLogValve)valve).setConditionUnless(arg_0));
        map.from(accessLogConfig.getDirectory()).to(arg_0 -> ((AccessLogValve)valve).setDirectory(arg_0));
        map.from(accessLogConfig.getEncoding()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setEncoding(arg_0));
        map.from(accessLogConfig.getPattern()).to(arg_0 -> ((AccessLogValve)valve).setPattern(arg_0));
        map.from(accessLogConfig.getPrefix()).to(arg_0 -> ((AccessLogValve)valve).setPrefix(arg_0));
        map.from(accessLogConfig.getSuffix()).to(arg_0 -> ((AccessLogValve)valve).setSuffix(arg_0));
        map.from(accessLogConfig.getLocale()).whenHasText().to(arg_0 -> ((AccessLogValve)valve).setLocale(arg_0));
        map.from(accessLogConfig.isCheckExists()).to(arg_0 -> ((AccessLogValve)valve).setCheckExists(arg_0));
        map.from(accessLogConfig.isRotate()).to(arg_0 -> ((AccessLogValve)valve).setRotatable(arg_0));
        map.from(accessLogConfig.isRenameOnRotate()).to(arg_0 -> ((AccessLogValve)valve).setRenameOnRotate(arg_0));
        map.from(accessLogConfig.getMaxDays()).to(arg_0 -> ((AccessLogValve)valve).setMaxDays(arg_0));
        map.from(accessLogConfig.getFileDateFormat()).to(arg_0 -> ((AccessLogValve)valve).setFileDateFormat(arg_0));
        map.from(accessLogConfig.isIpv6Canonical()).to(arg_0 -> ((AccessLogValve)valve).setIpv6Canonical(arg_0));
        map.from(accessLogConfig.isRequestAttributesEnabled()).to(arg_0 -> ((AccessLogValve)valve).setRequestAttributesEnabled(arg_0));
        map.from(accessLogConfig.isBuffered()).to(arg_0 -> ((AccessLogValve)valve).setBuffered(arg_0));
        map.from(accessLogConfig.getMaxLogMessageBufferSize()).to(arg_0 -> ((AccessLogValve)valve).setMaxLogMessageBufferSize(arg_0));
        factory.setAccessLog((Valve)valve);
    }

    private void customizeAuditLog(TongWebServletWebServerFactory factory, AuditLog log) {
        log.setTargetDir(this.serverProperties.getTongweb().getBasedir());
        factory.addContextLifecycleListeners(event -> {
            if (event.getType().equalsIgnoreCase("after_start")) {
                log.start();
            }
            if (event.getType().equalsIgnoreCase("before_destroy")) {
                log.stop();
            }
        });
    }

    private void customizeRemoteFilter(TongWebServletWebServerFactory factory, RemoteFilter remoteFilter) {
        PropertyMapper map = PropertyMapper.get();
        RemoteFilterConfigBean rf = new RemoteFilterConfigBean();
        map.from(remoteFilter.getAllowAddr()).whenNonNull().to(rf::setAllowAddr);
        map.from(remoteFilter.getAllowHost()).whenNonNull().to(rf::setAllowHost);
        map.from(remoteFilter.getDenyAddr()).whenNonNull().to(rf::setDenyAddr);
        map.from(remoteFilter.getDenyStatus()).whenNonNull().to(rf::setDenyStatus);
        map.from(remoteFilter.getDenyHost()).whenNonNull().to(rf::setDenyHost);
        factory.setRemoteFilter(rf);
    }

    private void customizeDocBase(TongWebServletWebServerFactory factory, String docBasePath) {
        factory.setDocumentRoot(new File(docBasePath));
        factory.addContextCustomizers(context -> context.setDocBase(docBasePath));
    }

    private void customizeWebApps(TongWebServletWebServerFactory factory, Map<String, String> webApps) {
        factory.setWebApps(webApps);
    }

    private void customizeStaticResources(TongWebServletWebServerFactory factory) {
        TongwebConfig.Resource resource = this.serverProperties.getTongweb().getResource();
        factory.addContextCustomizers(context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                context.getResources().setCacheTtl(resource.getCacheTtl());
                context.getResources().setCacheMaxSize(resource.getCacheMaxSize().longValue());
                context.getResources().setCacheObjectMaxSize(resource.getCacheObjectMaxSize().intValue());
            }
        }));
    }

    private void customizeErrorReportValve(TongWebServletWebServerFactory factory) {
        block9: {
            boolean jsonErrorReportValveEnabled = this.serverProperties.getTongweb().getJsonErrorReportValve().isEnabled();
            if (jsonErrorReportValveEnabled) {
                String errorValveClassName = "com.tongweb.container.valves.JsonErrorReportValve";
                JsonErrorReportValve valve = new JsonErrorReportValve();
                factory.addContextCustomizers(context -> {
                    StandardHost host = (StandardHost)context.getParent();
                    host.setErrorReportValveClass(errorValveClassName);
                    host.getPipeline().addValve((Valve)valve);
                });
            } else if (this.serverProperties.getTongweb().getErrorReportValve().isEnabled()) {
                boolean errorReportValveShowReport = this.serverProperties.getTongweb().getErrorReportValve().isShowReport();
                boolean errorReportValveShowServerInfo = this.serverProperties.getTongweb().getErrorReportValve().isShowServerInfo();
                this.generateErrorReportValve(factory, errorReportValveShowReport, errorReportValveShowServerInfo);
            } else if (!StringUtils.isEmpty((Object)this.serverProperties.getTongweb().getCustomizedErrorReportValve().getType())) {
                String customizedErrorValveType = this.serverProperties.getTongweb().getCustomizedErrorReportValve().getType();
                try {
                    Object customizedErrorValveObj = Class.forName(customizedErrorValveType).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (customizedErrorValveObj instanceof ErrorReportValve) {
                        ErrorReportValve customizedErrorValve = (ErrorReportValve)customizedErrorValveObj;
                        factory.addContextCustomizers(context -> {
                            StandardHost host = (StandardHost)context.getParent();
                            host.getPipeline().addValve((Valve)customizedErrorValve);
                        });
                        break block9;
                    }
                    logger.warn((Object)("customize valve class " + customizedErrorValveType + " is invalid , customized errorValve failed."));
                }
                catch (Throwable e) {
                    logger.warn((Object)("class " + customizedErrorValveType + " not exist. customized errorValve failed."), e);
                }
            } else {
                this.generateErrorReportValve(factory, true, false);
            }
        }
    }

    private void customizeSecurityListener(TongWebServletWebServerFactory factory) {
        boolean securityEnabled = this.serverProperties.getTongweb().getSecurityListener().isEnabled();
        boolean removeRootUser = this.serverProperties.getTongweb().getSecurityListener().isRemoveRootUser();
        String minimumUmask = this.serverProperties.getTongweb().getSecurityListener().getMinimumUmask();
        String checkedOsUsers = this.serverProperties.getTongweb().getSecurityListener().getCheckedOsUsers();
        if (securityEnabled) {
            SecurityListener securityListener = new SecurityListener();
            if (!StringUtils.isEmpty((Object)minimumUmask)) {
                securityListener.setMinimumUmask(minimumUmask);
            }
            if (removeRootUser) {
                securityListener.setCheckedOsUsers("");
            }
            if (!StringUtils.isEmpty((Object)checkedOsUsers)) {
                securityListener.setCheckedOsUsers(checkedOsUsers);
            }
            factory.addContextLifecycleListeners(new LifecycleListener[]{securityListener});
        }
    }

    private void generateErrorReportValve(TongWebServletWebServerFactory factory, boolean showReport, boolean showServerInfo) {
        ErrorReportValve valve = new ErrorReportValve();
        valve.setShowReport(showReport);
        valve.setShowServerInfo(showServerInfo);
        factory.addContextCustomizers(context -> {
            StandardHost host = (StandardHost)context.getParent();
            host.setErrorReportValveClass(valve.getClass().getCanonicalName());
            host.getPipeline().addValve((Valve)valve);
        });
    }
}

