/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.reactive.adapter;

import com.tongweb.container.connector.CoyoteInputStream;
import com.tongweb.container.connector.CoyoteOutputStream;
import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.RequestFacade;
import com.tongweb.container.connector.Response;
import com.tongweb.container.connector.ResponseFacade;
import com.tongweb.springboot.reactive.adapter.TongWebHeadersAdapter52;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.servlet.AsyncContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter52;
import org.springframework.http.server.reactive.ServletServerHttpRequest52;
import org.springframework.http.server.reactive.ServletServerHttpResponse52;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class TongWebHttpHandlerAdapter52
extends ServletHttpHandlerAdapter52 {
    public TongWebHttpHandlerAdapter52(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpRequest52 createRequest(HttpServletRequest request, AsyncContext asyncContext) throws IOException, URISyntaxException {
        Assert.notNull((Object)this.getServletPath(), (String)"Servlet path is not initialized");
        return new TongWebServerHttpRequest(request, asyncContext, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServletServerHttpResponse52 createResponse(HttpServletResponse response, AsyncContext asyncContext, ServletServerHttpRequest52 request) throws IOException {
        return new TongWebServerHttpResponse(response, asyncContext, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class TongWebServerHttpResponse
    extends ServletServerHttpResponse52 {
        private static final Field COYOTE_RESPONSE_FIELD;

        TongWebServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize, ServletServerHttpRequest52 request) throws IOException {
            super(TongWebServerHttpResponse.createTongWebHttpHeaders(response), response, context, factory, bufferSize, request);
        }

        private static HttpHeaders createTongWebHttpHeaders(HttpServletResponse response) {
            ResponseFacade responseFacade = TongWebServerHttpResponse.getResponseFacade(response);
            Response connectorResponse = (Response)ReflectionUtils.getField((Field)COYOTE_RESPONSE_FIELD, (Object)responseFacade);
            Assert.state((connectorResponse != null ? 1 : 0) != 0, (String)"No TongWeb connector response");
            com.tongweb.connector.Response tongWebResponse = connectorResponse.getCoyoteResponse();
            TongWebHeadersAdapter52 headers = new TongWebHeadersAdapter52(tongWebResponse.getMimeHeaders());
            return new HttpHeaders((MultiValueMap)headers);
        }

        private static ResponseFacade getResponseFacade(HttpServletResponse response) {
            if (response instanceof ResponseFacade) {
                return (ResponseFacade)response;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return TongWebServerHttpResponse.getResponseFacade(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + response.getClass() + "] to com.tongweb.container.connector.ResponseFacade");
        }

        @Override
        protected void applyHeaders() {
            long contentLength;
            Charset charset;
            HttpServletResponse response = (HttpServletResponse)this.getNativeResponse();
            MediaType contentType = null;
            try {
                contentType = this.getHeaders().getContentType();
            }
            catch (Exception ex) {
                String rawContentType = this.getHeaders().getFirst("Content-Type");
                response.setContentType(rawContentType);
            }
            if (response.getContentType() == null && contentType != null) {
                response.setContentType(contentType.toString());
            }
            this.getHeaders().remove((Object)"Content-Type");
            Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
            if (response.getCharacterEncoding() == null && charset != null) {
                response.setCharacterEncoding(charset.name());
            }
            if ((contentLength = this.getHeaders().getContentLength()) != -1L) {
                response.setContentLengthLong(contentLength);
            }
            this.getHeaders().remove((Object)"Content-Length");
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ServletResponse response = (ServletResponse)this.getNativeResponse();
            ((CoyoteOutputStream)response.getOutputStream()).write(input);
            return len;
        }

        static {
            Field field = ReflectionUtils.findField(ResponseFacade.class, (String)"response");
            Assert.state((field != null ? 1 : 0) != 0, (String)"Incompatible TongWeb implementation");
            ReflectionUtils.makeAccessible((Field)field);
            COYOTE_RESPONSE_FIELD = field;
        }
    }

    private static final class TongWebServerHttpRequest
    extends ServletServerHttpRequest52 {
        private static final Field COYOTE_REQUEST_FIELD;
        private final int bufferSize;
        private final DataBufferFactory factory;

        TongWebServerHttpRequest(HttpServletRequest request, AsyncContext context, String servletPath, DataBufferFactory factory, int bufferSize) throws IOException, URISyntaxException {
            super(TongWebServerHttpRequest.createTongWebHttpHeaders(request), request, context, servletPath, factory, bufferSize);
            this.factory = factory;
            this.bufferSize = bufferSize;
        }

        private static HttpHeaders createTongWebHttpHeaders(HttpServletRequest request) {
            RequestFacade requestFacade = TongWebServerHttpRequest.getRequestFacade(request);
            Request connectorRequest = (Request)ReflectionUtils.getField((Field)COYOTE_REQUEST_FIELD, (Object)requestFacade);
            Assert.state((connectorRequest != null ? 1 : 0) != 0, (String)"No TongWeb connector request");
            com.tongweb.connector.Request tongwebRequest = connectorRequest.getCoyoteRequest();
            TongWebHeadersAdapter52 headers = new TongWebHeadersAdapter52(tongwebRequest.getMimeHeaders());
            return new HttpHeaders((MultiValueMap)headers);
        }

        private static RequestFacade getRequestFacade(HttpServletRequest request) {
            if (request instanceof RequestFacade) {
                return (RequestFacade)request;
            }
            if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return TongWebServerHttpRequest.getRequestFacade(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + request.getClass() + "] to com.tongweb.container.connector.RequestFacade");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataBuffer readFromInputStream() throws IOException {
            ServletInputStream inputStream = ((ServletRequest)this.getNativeRequest()).getInputStream();
            if (!(inputStream instanceof CoyoteInputStream)) {
                return super.readFromInputStream();
            }
            boolean release = true;
            int capacity = this.bufferSize;
            DataBuffer dataBuffer = this.factory.allocateBuffer(capacity);
            try {
                ByteBuffer byteBuffer = dataBuffer.asByteBuffer(0, capacity);
                int read = ((CoyoteInputStream)inputStream).read(byteBuffer);
                this.logBytesRead(read);
                if (read > 0) {
                    dataBuffer.writePosition(read);
                    release = false;
                    DataBuffer dataBuffer2 = dataBuffer;
                    return dataBuffer2;
                }
                if (read == -1) {
                    DataBuffer dataBuffer3 = EOF_BUFFER;
                    return dataBuffer3;
                }
                DataBuffer dataBuffer4 = null;
                return dataBuffer4;
            }
            finally {
                if (release) {
                    DataBufferUtils.release((DataBuffer)dataBuffer);
                }
            }
        }

        static {
            Field field = ReflectionUtils.findField(RequestFacade.class, (String)"request");
            Assert.state((field != null ? 1 : 0) != 0, (String)"Incompatible TongWeb implementation");
            ReflectionUtils.makeAccessible((Field)field);
            COYOTE_REQUEST_FIELD = field;
        }
    }
}

