/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.starter;

import com.tongtech.commons.license.LicenseSDKProvider;
import com.tongtech.commons.license.utils.EnvConfigEnum;
import com.tongtech.commons.utils.ClashPreventUtils;
import com.tongtech.commons.utils.SystemExitUtil;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Valve;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.AprLifecycleListener;
import com.tongweb.container.loader.WebappClassLoaderBase;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.util.ServerInfo;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.springboot.properties.IoMode;
import com.tongweb.springboot.properties.PropertyMapper;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.properties.TongwebConfig;
import com.tongweb.springboot.reactive.adapter.TongWebHttpHandlerAdapter51;
import com.tongweb.springboot.reactive.adapter.TongWebHttpHandlerAdapter52;
import com.tongweb.springboot.reactive.adapter.TongWebHttpHandlerAdapter53;
import com.tongweb.springboot.starter.CheckIntegrityUtil;
import com.tongweb.springboot.starter.CompressionConnectorCustomizer;
import com.tongweb.springboot.starter.ConfigurableTongWebServerFactory;
import com.tongweb.springboot.starter.DisableReferenceClearingContextCustomizer;
import com.tongweb.springboot.starter.SslConnectorCustomizer;
import com.tongweb.springboot.starter.TongWebConnectorCustomizer;
import com.tongweb.springboot.starter.TongWebContextCustomizer;
import com.tongweb.springboot.starter.TongWebEmbedContext;
import com.tongweb.springboot.starter.TongWebEmbedWebappClassLoader;
import com.tongweb.springboot.starter.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.starter.TongWebServer;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class TongWebReactiveWebServerFactory
extends AbstractReactiveWebServerFactory
implements ConfigurableTongWebServerFactory {
    private static Log log = LogFactory.getLog(TongWebReactiveWebServerFactory.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Autowired
    private TongWebProperties tongWebProperties;
    @Autowired
    private ApplicationContext context;
    public static final String DEFAULT_PROTOCOL = "com.tongweb.connector.http11.Http11NioProtocol";
    private File baseDirectory;
    private final List<Valve> engineValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private Set<TongWebContextCustomizer> tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>();
    private Set<TongWebConnectorCustomizer> tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>();
    private Set<TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizers = new LinkedHashSet();
    private final List<Connector> additionalTongWebConnectors = new ArrayList<Connector>();
    private String protocol = "com.tongweb.connector.http11.Http11NioProtocol";
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;
    private boolean disableMBeanRegistry = true;

    private static List<LifecycleListener> getDefaultLifecycleListeners() {
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable() ? new ArrayList<AprLifecycleListener>(Collections.singletonList(aprLifecycleListener)) : new ArrayList();
    }

    public TongWebReactiveWebServerFactory() {
    }

    public TongWebReactiveWebServerFactory(int port) {
        super(port);
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        Object servlet;
        System.setProperty("java.security.egd", "file:/dev/./urandom");
        this.checkLicense();
        try {
            ClashPreventUtils.check();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        if (this.disableMBeanRegistry) {
            Registry.disableRegistry();
        }
        ServletContainer servletContainer = new ServletContainer();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tongweb");
        servletContainer.setBaseDir(baseDir.getAbsolutePath());
        if (this.protocol.equalsIgnoreCase(IoMode.APR.getClassName())) {
            AprLifecycleListener arpLifecycle = new AprLifecycleListener();
            this.addContextLifecycleListeners(new LifecycleListener[]{arpLifecycle});
        }
        Connector connector = new Connector(this.protocol);
        connector.setThrowOnFailure(true);
        servletContainer.getService().addConnector(connector);
        this.customizeConnector(connector);
        servletContainer.setConnector(connector);
        servletContainer.getHost().setAutoDeploy(false);
        this.configureEngine(servletContainer.getEngine());
        for (Connector additionalConnector : this.additionalTongWebConnectors) {
            servletContainer.getService().addConnector(additionalConnector);
        }
        String springVersion = SpringVersion.getVersion();
        if (springVersion != null && springVersion.startsWith("5.")) {
            servlet = springVersion.startsWith("5.1") ? new TongWebHttpHandlerAdapter51(httpHandler) : (springVersion.startsWith("5.2") ? new TongWebHttpHandlerAdapter52(httpHandler) : (springVersion.startsWith("5.3") ? new TongWebHttpHandlerAdapter53(httpHandler) : new TongWebHttpHandlerAdapter53(httpHandler)));
        } else {
            log.warn((Object)("only support spring 5.x, the current version is [" + springVersion + "]. Notify Customer service, please!"));
            servlet = new TongWebHttpHandlerAdapter53(httpHandler);
        }
        this.prepareContext(servletContainer.getHost(), (Servlet)servlet);
        return this.getTongWebServer(servletContainer);
    }

    private void checkLicense() {
        ServerInfo.getServerENumber();
        SystemExitUtil.setHook(() -> System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0})));
        new CheckIntegrityUtil();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(this.tongWebProperties.getTongweb()).whenNonNull().as(TongwebConfig::getLicense).whenNonNull().to(license -> {
            propertyMapper.from(license.getType().getValidateType()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_LICENSE_TYPE).setSystemProperty(arg_0));
            propertyMapper.from(license.getLicenseIps()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_IPS).setSystemProperty(arg_0));
            propertyMapper.from(license.getLicensePublicKey()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_PUBLIC_KEY).setSystemProperty(arg_0));
            propertyMapper.from(license.getPath()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_FILE_PATH).setSystemProperty(arg_0));
            propertyMapper.from(license.isSync()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_IS_SYNC).setSystemProperty(arg_0));
            propertyMapper.from(license.isSslEnabled()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_ENABLED).setSystemProperty(arg_0));
            propertyMapper.from(license.getSsl()).whenNonNull().to(ssl -> {
                propertyMapper.from(ssl.getKeyStore()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_KEY_STORE).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getKeyStorePassword()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_KEY_STORE_PASSWORD).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getKeyStoreType()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_KEY_STORE_TYPE).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getTrustStore()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_TRUST_STORE).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getTrustStorePassword()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_TRUST_STORE_PASSWORD).setSystemProperty(arg_0));
                propertyMapper.from(ssl.getTrustStoreType()).to(arg_0 -> ((EnvConfigEnum)EnvConfigEnum.LICENSE_SSL_TRUST_STORE_TYPE).setSystemProperty(arg_0));
            });
        });
        LicenseSDKProvider.validate();
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, Servlet servlet) {
        File docBase = this.createTempDir("tongweb-docbase");
        TongWebEmbedContext context = new TongWebEmbedContext();
        context.setPath("");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new ServletContainer.FixContextListener());
        ClassLoader parentClassLoader = ClassUtils.getDefaultClassLoader();
        context.setParentClassLoader(parentClassLoader);
        this.skipAllTldScanning(context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderInstance((WebappClassLoaderBase)new TongWebEmbedWebappClassLoader(parentClassLoader));
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        ServletContainer.addServlet((Context)context, (String)"httpHandlerServlet", (Servlet)servlet).setAsyncSupported(true);
        context.addServletMappingDecoded("/", "httpHandlerServlet");
        host.addChild((Container)context);
        this.configureContext((Context)context);
    }

    private void skipAllTldScanning(TongWebEmbedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip("*.jar");
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    protected void configureContext(Context context) {
        this.contextLifecycleListeners.forEach(arg_0 -> ((Context)context).addLifecycleListener(arg_0));
        new DisableReferenceClearingContextCustomizer().customize(context);
        this.tongWebContextCustomizers.forEach(customizer -> customizer.customize(context));
    }

    protected void customizeConnector(Connector connector) {
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setAttribute("server", (Object)this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        this.invokeProtocolHandlerCustomizers(connector.getProtocolHandler());
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.tongWebProperties);
        compression.customize(connector);
        for (TongWebConnectorCustomizer customizer : this.tongWebConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    private void invokeProtocolHandlerCustomizers(ProtocolHandler protocolHandler) {
        LambdaSafe.callbacks(TongWebProtocolHandlerCustomizer.class, this.tongWebProtocolHandlerCustomizers, (Object)protocolHandler, (Object[])new Object[0]).invoke(customizer -> customizer.customize(protocolHandler));
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getSslStoreProvider()).customize(connector);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public void setTongWebContextCustomizers(Collection<? extends TongWebContextCustomizer> tongWebContextCustomizers) {
        Assert.notNull(tongWebContextCustomizers, (String)"TongwebContextCustomizers must not be null");
        this.tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>(tongWebContextCustomizers);
    }

    public Collection<TongWebContextCustomizer> getTongWebContextCustomizers() {
        return this.tongWebContextCustomizers;
    }

    @Override
    public void addContextCustomizers(TongWebContextCustomizer ... tongWebContextCustomizers) {
        Assert.notNull((Object)tongWebContextCustomizers, (String)"TongwebContextCustomizers must not be null");
        this.tongWebContextCustomizers.addAll(Arrays.asList(tongWebContextCustomizers));
    }

    public void setTongWebConnectorCustomizers(Collection<? extends TongWebConnectorCustomizer> tongWebConnectorCustomizers) {
        Assert.notNull(tongWebConnectorCustomizers, (String)"TongwebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>(tongWebConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(TongWebConnectorCustomizer ... tongWebConnectorCustomizers) {
        Assert.notNull((Object)tongWebConnectorCustomizers, (String)"TongwebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers.addAll(Arrays.asList(tongWebConnectorCustomizers));
    }

    public Collection<TongWebConnectorCustomizer> getTongWebConnectorCustomizers() {
        return this.tongWebConnectorCustomizers;
    }

    public void setTongWebProtocolHandlerCustomizers(Collection<? extends TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizers) {
        Assert.notNull(tongWebProtocolHandlerCustomizers, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers = new LinkedHashSet(tongWebProtocolHandlerCustomizers);
    }

    @Override
    public void addProtocolHandlerCustomizers(TongWebProtocolHandlerCustomizer<?> ... tongWebProtocolHandlerCustomizers) {
        Assert.notNull(tongWebProtocolHandlerCustomizers, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers.addAll(Arrays.asList(tongWebProtocolHandlerCustomizers));
    }

    public Collection<TongWebProtocolHandlerCustomizer<?>> getTongWebProtocolHandlerCustomizers() {
        return this.tongWebProtocolHandlerCustomizers;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public List<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    protected TongWebServer getTongWebServer(ServletContainer servletContainer) {
        return new TongWebServer(servletContainer, this.getPort() >= 0);
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        this.disableMBeanRegistry = disableMBeanRegistry;
    }
}

