/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.commons.utils;

import com.tongtech.commons.utils.StringUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPUtils {
    public static List<String> getLocalIp() {
        ArrayList<String> list = new ArrayList<String>();
        InetAddress addr = null;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enAddr = intf.getInetAddresses();
                while (enAddr.hasMoreElements()) {
                    addr = enAddr.nextElement();
                    if (addr instanceof Inet4Address) {
                        list.add(addr.getHostAddress().split("%")[0]);
                    }
                    if (!(addr instanceof Inet6Address)) continue;
                    list.add(addr.getHostAddress().split("%")[0]);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getCause().getMessage());
            return list;
        }
        return list;
    }

    public static boolean ipMatch(String ips, String ip) {
        if (ips.contains(".")) {
            String[] validips = ips.split("\\.");
            String re = "";
            for (int j2 = 0; j2 < validips.length; ++j2) {
                String num = validips[j2].toString();
                re = !num.equals("*") ? re + num + "." : re + "\\d{0,3}.";
                if (j2 != validips.length - 1) continue;
                re = re.substring(0, re.length() - 1).toString();
            }
            Pattern pattern = Pattern.compile(re);
            Matcher matcher = pattern.matcher(ip);
            return matcher.matches();
        }
        if (ips.contains(":")) {
            String[] validips = ips.split(":");
            String re = "";
            for (int j3 = 0; j3 < validips.length; ++j3) {
                String num = validips[j3].toString();
                if (!num.equals("*")) {
                    if (num.isEmpty()) {
                        int len = 9 - validips.length;
                        for (int t = 0; t < len; ++t) {
                            re = re + "0:";
                        }
                    } else {
                        re = re + num + ":";
                    }
                } else {
                    re = re + "[\\da-z]{0,4}:";
                }
                if (j3 != validips.length - 1) continue;
                re = re.substring(0, re.length() - 1).toString();
            }
            Pattern pattern = Pattern.compile(re);
            Matcher matcher = pattern.matcher(ip);
            return matcher.matches();
        }
        return false;
    }

    public static long ipTolong(InetAddress ip) {
        byte[] ipAdds;
        long result = 0L;
        for (byte b2 : ipAdds = ip.getAddress()) {
            result <<= 8;
            result |= (long)(b2 & 0xFF);
        }
        return result;
    }

    public static boolean checkIPAddress(String ipStr) {
        if (StringUtils.isEmpty(ipStr)) {
            return false;
        }
        String ipv4Regex = "[a-zA-z]*:*/*[^\\s]*";
        String ipv6Regex = "\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]:(\\d+)";
        return IPUtils.checkByRegex(ipStr, ipv4Regex) || IPUtils.checkByRegex(ipStr, ipv6Regex);
    }

    public static boolean checkByRegex(String ipStr, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ipStr);
        return matcher.matches();
    }

    public static List<String> getLocalMacs() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                mac = netInterface.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < mac.length; ++i2) {
                    sb.append(String.format("%02X%s", mac[i2], ""));
                }
                if (sb.length() <= 0) continue;
                list.add(sb.toString());
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getCause().getMessage());
            return list;
        }
        return list;
    }
}

