package com.testor.common.core.domain;

import com.testor.common.core.enums.BaseStatusEnum;
import io.swagger.annotations.ApiModelProperty;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class BaseResponse<T> {
    private static final long serialVersionUID = 1454472377201201505L;
    @ApiModelProperty(
        value = "内部记录ID",
        required = false
    )
    private String requestId;
    @ApiModelProperty(
        value = "响应代码",
        required = false,
        example = "200"
    )
    private Integer code;
    @ApiModelProperty(
        value = "响应信息",
        required = false
    )
    private String msg;
    @ApiModelProperty(
        value = "结果数据",
        required = false
    )
    private T data;
    @ApiModelProperty(
        value = "响应类型",
        required = false
    )
    private String type;

    public BaseResponse() {
        this.code = BaseStatusEnum.SUCCESS.code();
        this.msg = BaseStatusEnum.SUCCESS.msg();
    }

    static ParameterizedType type(final Class raw, final Type... args) {
        return new ParameterizedType() {
            public Type getRawType() {
                return raw;
            }

            public Type[] getActualTypeArguments() {
                return args;
            }

            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static BaseResponse success() {
        return new BaseResponse();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public String getType() {
        return this.type;
    }

    public void setRequestId(final String requestId) {
        this.requestId = requestId;
    }

    public void setCode(final Integer code) {
        this.code = code;
    }

    public void setMsg(final String msg) {
        this.msg = msg;
    }

    public void setData(final T data) {
        this.data = data;
    }

    public void setType(final String type) {
        this.type = type;
    }

    public String toString() {
        return "BaseResponse(requestId=" + this.getRequestId() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", type=" + this.getType() + ")";
    }

    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof BaseResponse)) {
            return false;
        } else {
            BaseResponse<?> other = (BaseResponse)o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                label71: {
                    Object this$code = this.getCode();
                    Object other$code = other.getCode();
                    if (this$code == null) {
                        if (other$code == null) {
                            break label71;
                        }
                    } else if (this$code.equals(other$code)) {
                        break label71;
                    }

                    return false;
                }

                Object this$requestId = this.getRequestId();
                Object other$requestId = other.getRequestId();
                if (this$requestId == null) {
                    if (other$requestId != null) {
                        return false;
                    }
                } else if (!this$requestId.equals(other$requestId)) {
                    return false;
                }

                label57: {
                    Object this$msg = this.getMsg();
                    Object other$msg = other.getMsg();
                    if (this$msg == null) {
                        if (other$msg == null) {
                            break label57;
                        }
                    } else if (this$msg.equals(other$msg)) {
                        break label57;
                    }

                    return false;
                }

                Object this$data = this.getData();
                Object other$data = other.getData();
                if (this$data == null) {
                    if (other$data != null) {
                        return false;
                    }
                } else if (!this$data.equals(other$data)) {
                    return false;
                }

                Object this$type = this.getType();
                Object other$type = other.getType();
                if (this$type == null) {
                    if (other$type == null) {
                        return true;
                    }
                } else if (this$type.equals(other$type)) {
                    return true;
                }

                return false;
            }
        }
    }

    protected boolean canEqual(final Object other) {
        return other instanceof BaseResponse;
    }
}