package com.testor.common.constant;

/**
 * @ClassName: IamMessageStatusEnum
 * @Description: IAM消息状态枚举
 * @Author: lm
 * @CreateTime: 2024/1/2 14:53
 * @Version: 1.0
 */
public enum IamMessageStatusEnum {

    NEW("0", "新消息"),
    FAIL("1", "处理失败"),
    SUCCESS("2","处理成功"),
    IGNORE("3", "忽略");

    private  String code;
    private  String msg;

    private IamMessageStatusEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static IamMessageStatusEnum getIamMessageStatusByCode(String code) {
        IamMessageStatusEnum[] values = values();
        for (IamMessageStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
    public static IamMessageStatusEnum getIamMessageStatusByMsg(String msg) {
        IamMessageStatusEnum[] values = values();
        for (IamMessageStatusEnum value : values) {
            if (value.getMsg().equals(msg)) {
                return value;
            }
        }
        return null;
    }}
