package com.testor.common.util;

import org.apache.commons.lang.StringUtils;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 枚举工具类
 * @date 2022/5/20 19:31
 */
public class EnumUtil {

    public static <T extends CodeEnum> String getByCode(String code, Class<T> t) {
        for (T item : t.getEnumConstants()) {
            if (item.getCode().equals(code)) {
                return item.getMsg();
            }
        }
        return "";
    }

    public static <T extends CodeEnum> String getByMsg(String msg, Class<T> t) {
        for (T item : t.getEnumConstants()) {

            if (StringUtils.equals(item.getMsg(), msg)) {
                return item.getCode();
            }
        }
        return "";
    }
}
