package com.testor.ddd.safetyControl.application.service.riskLeclsManage;

import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.*;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.exception.BusinessException;

import java.util.List;

public interface RiskLeclsManageService {
    /**
     * @param riskLeclsConfDtoList
     * @return
     */
    BaseResponse<List<TSafeRiskLeclsConfDTO>> editRiskLeclsConf(List<TSafeRiskLeclsConfDTO> riskLeclsConfDtoList) throws BusinessException;

    TSafeRiskLeclsConfDTO findById(String id);

    BaseResponse deleteById(String id) throws BusinessException;

    List<TSafeRiskLeclsConfDTO> listAllEntity(TSafeRiskLeclsConfDTOParam param);

    /**
     * 编辑空间
     * @param riskLeclsRelationDtoList
     * @return
     */
    BaseResponse<List<TSafeRiskLeclsRelationDTO>> editRiskLeclsRelation(List<TSafeRiskLeclsRelationDTO> riskLeclsRelationDtoList) throws BusinessException;

    TSafeRiskLeclsRelationDTO findRelationById(String id);

    BaseResponse deleteRelationById(String id) throws BusinessException;

    BaseResponse deleteRelationByType(Integer type);

    List<TSafeRiskLeclsRelationDTO> listRelationAllEntity(TSafeRiskLeclsRelationDTOParam param);

    /**
     * 根据 lec/ls 计算 现实风险等级
     * @param leclsValDTO
     */
    TSafeRiskRealLevelRelationDTO findLevelByLecls(RiskLeclsValDTO leclsValDTO) throws BusinessException;
}
