package com.testor.ddd.safetyControl.application.service.riskSourceManage.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.application.service.riskSourceManage.RiskSourceRecordManageService;
import com.testor.ddd.safetyControl.domain.riskSource.entity.TSafeRiskSourceRecordRepo;
import com.testor.ddd.safetyControl.domain.riskSource.service.RiskSourceRecordService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceRecordDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceRecordDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceRecordVO;
import com.testor.module.sys.model.vo.SysOrgVo;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class RiskSourceRecordManageServiceImpl implements RiskSourceRecordManageService {

    @Resource
    private RiskSourceRecordService riskSourceRecordService;

    @Resource
    private TSafeRiskSourceRecordRepo tSafeRiskSourceRecordRepo;

    @Resource
    private NewSysOrgService newSysOrgService;


    /**
     * @param operateType 操作类型(1-新增；2-修改；3-删除)
     * @return
     */
    @Transactional
    public void editRiskSourceRecord(String sourceId, Integer operateType) {
        if(StrUtil.isBlank(sourceId) || operateType == null) {
            return;
        }
       // LocalDateTime nowDate = new Date();
        UserInfo curUser = ContextUtils.getLoginUser();
        TSafeRiskSourceRecordDTO sourceRecordDTO = new TSafeRiskSourceRecordDTO();
        sourceRecordDTO.setSourceId(sourceId);
        sourceRecordDTO.setOrgId(curUser.getOrgId());
        sourceRecordDTO.setUserId(curUser.getUserId());
        sourceRecordDTO.setOperateType(operateType);
      //  sourceRecordDTO.setCreateDate(nowDate);
        sourceRecordDTO = tSafeRiskSourceRecordRepo.insert(sourceRecordDTO);
        if(sourceRecordDTO == null) {
            log.error("危险源【{}】操作记录失败");
        }
        return ;

    }

    public BaseResponseList<TSafeRiskSourceRecordVO> listByPage(TSafeRiskSourceRecordDTOParam param) {

        if (StrUtil.isBlank(param.getOrgId())) {
            UserInfo curUser = ContextUtils.getLoginUser();
            String curUserOrgId = curUser.getOrgId();
            param.setOrgId(curUserOrgId);
        }

        BaseResponseList<TSafeRiskSourceRecordVO> responseList = riskSourceRecordService.listByPage(param);
        List<TSafeRiskSourceRecordVO> list = responseList.getData();
        if(list == null || list.size() == 0){
            return responseList;
        }
        List<TSafeRiskSourceRecordVO> finalResultList = list.parallelStream().map(vo -> {
            SysOrgVo sysOrgVo = newSysOrgService.lookOrg(vo.getOrgId());
            vo.setOrgFullName(sysOrgVo.getPath());
            return vo;
        }).collect(Collectors.toList());
        return responseList;
    }
}
