package com.testor.ddd.safetyControl.domain.equipment.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeEquipmentTypeRepo {

    /**
     * 检测 名称、编码 是否都唯一(全局唯一)
     * @param id
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeEquipmentTypeDTO> checkUniqueness(String id, String name, String code);

    int insert(TSafeEquipmentTypeDTO equipmentTypeDTO);

    int updateById(TSafeEquipmentTypeDTO equipmentTypeDTO);
    /**
     * 分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeEquipmentTypeVO> listPage(TSafeEquipmentTypeDTOParam param);

    TSafeEquipmentTypeDTO findById(String id);

    boolean deleteById(String id);
}
