package com.testor.ddd.safetyControl.domain.riskSource.service;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

public interface RiskSourceService {

    /**
     * 编辑空间
     * @param riskSourceOrgDto
     * @return
     */
    BaseResponse<TSafeRiskSourceDTO> editRiskSource(String userId, String orgId, TSafeRiskSourceDTO riskSourceOrgDto);

    BaseResponseList<TSafeRiskSourceVO> listByPage(TSafeRiskSourceDTOParam param);

    TSafeRiskSourceDTO findById(String id);

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String orgId, String sourceId, String name);

    /**
     * 危险源导出数据列表
     * @param param
     * @return
     */
    List<TSafeRiskSourceVO> listExpData(TSafeRiskSourceDTOParam param);
}
