package com.testor.ddd.safetyControl.domain.space.service;

import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

public interface SpaceService {

    /**
     * 检测 名称、编码 是否都唯一
     * @param bizId level = 1 时 此值为space_type_id；2 :space_id
     * @param level 等级 1-车间场所名称；2-作业区域
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String id, String bizId, Integer level, String name, String code);

    /**
     * 编辑空间
     * @param spaceOrgDto
     * @return
     */
    BaseResponse editSpace(String userId, String orgId, TSafeSpaceDTO spaceOrgDto);

    BaseResponseList<TSafeSpaceVO> listByPage(TSafeSpaceDTOParam param);

    /**
     * 根据编码查询
     * @param code
     * @return
     */
    List<TSafeSpaceVO> listByCode(String code);

    TSafeSpaceDTO findById(String id);

    List<TSafeSpaceDTO> myList(String orgId);

    List<TSafeSpaceVO> listSafeSpaceAll(TSafeSpaceDTOParam param);

}
