package com.testor.ddd.safetyControl.infrastructure.repository.lecls.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.testor.ddd.safetyControl.domain.lecls.entity.TSafeRiskLeclsConfRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.lecls.dao.TSafeRiskLeclsConfDao;
import com.testor.ddd.safetyControl.infrastructure.repository.lecls.entity.TSafeRiskLeclsConfDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.TSafeRiskLeclsConfDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.TSafeRiskLeclsConfDTOParam;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskLeclsConfServiceImpl extends SuperServiceImpl<TSafeRiskLeclsConfDao, TSafeRiskLeclsConfDO>
        implements TSafeRiskLeclsConfRepo
{
    @Autowired(required = false)
    private TSafeRiskLeclsConfDao tSafeRiskLeclsConfDao;

    public TSafeRiskLeclsConfDTO insert(TSafeRiskLeclsConfDTO riskLeclsConfDTO){
        TSafeRiskLeclsConfDO data = BeanHelper.beanToBean(riskLeclsConfDTO, TSafeRiskLeclsConfDO.class);
        int result = tSafeRiskLeclsConfDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskLeclsConfDTO = BeanHelper.beanToBean(data, TSafeRiskLeclsConfDTO.class);
        return riskLeclsConfDTO;
    }

    public TSafeRiskLeclsConfDTO updateById(TSafeRiskLeclsConfDTO riskLeclsConfDTO){
        TSafeRiskLeclsConfDO data = BeanHelper.beanToBean(riskLeclsConfDTO, TSafeRiskLeclsConfDO.class);
        int result = tSafeRiskLeclsConfDao.updateById(data);
        if(result < 1) {
            return null;
        }
        riskLeclsConfDTO = BeanHelper.beanToBean(data, TSafeRiskLeclsConfDTO.class);
        return riskLeclsConfDTO;
    }
    
    public TSafeRiskLeclsConfDTO findById(String id){
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskLeclsConfDO riskLeclsConfDo = tSafeRiskLeclsConfDao.selectById(id);
        TSafeRiskLeclsConfDTO riskLeclsConfDTO = BeanHelper.beanToBean(riskLeclsConfDo, TSafeRiskLeclsConfDTO.class);
        return riskLeclsConfDTO;
    }

    public boolean deleteById(String id){
        UpdateWrapper<TSafeRiskLeclsConfDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskLeclsConfDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskLeclsConfDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskLeclsConfDO::getId,id);
        return update(updateWrapper);
    }
    
    public List<TSafeRiskLeclsConfDTO> listAllEntity(TSafeRiskLeclsConfDTOParam param){
        QueryWrapper<TSafeRiskLeclsConfDO> queryWrapper=this.createQuery(param);
        List<TSafeRiskLeclsConfDO> resultList=list(queryWrapper);
        List<TSafeRiskLeclsConfDTO> resultDTOList= BeanHelper.listToList(resultList, TSafeRiskLeclsConfDTO.class);
        return resultDTOList;
    }

    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeRiskLeclsConfDO> createQuery(TSafeRiskLeclsConfDTOParam queryParam){
        QueryWrapper<TSafeRiskLeclsConfDO> queryWrapper=new QueryWrapper<>();
        if(ObjectHelper.isNotEmpty(queryParam.getType())){
            queryWrapper.eq(TSafeRiskLeclsConfDO.TYPE,queryParam.getType());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getMaxValue())){
            queryWrapper.eq(TSafeRiskLeclsConfDO.MAX_VALUE,queryParam.getMaxValue());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getMinValue())){
            queryWrapper.eq(TSafeRiskLeclsConfDO.MIN_VALUE,queryParam.getMinValue());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getMinRange())){
            queryWrapper.eq(TSafeRiskLeclsConfDO.MIN_RANGE,queryParam.getMinRange());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSafeRiskLeclsConfDO.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getCode())){
            queryWrapper.eq(TSafeRiskLeclsConfDO.CODE,queryParam.getCode());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeRiskLeclsConfDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeRiskLeclsConfDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeRiskLeclsConfDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

    public boolean saveBatch(List<TSafeRiskLeclsConfDTO> riskLeclsConfDTOList){
        List<TSafeRiskLeclsConfDO> riskLeclsConfDOList = BeanHelper.listToList(riskLeclsConfDTOList, TSafeRiskLeclsConfDO.class);
        return saveBatch(riskLeclsConfDOList);
    }

    public List<TSafeRiskLeclsConfDTO> saveOrUpdateBatch(List<TSafeRiskLeclsConfDTO> riskLeclsConfDTOList){
        List<TSafeRiskLeclsConfDO> riskLeclsConfDOList = BeanHelper.listToList(riskLeclsConfDTOList, TSafeRiskLeclsConfDO.class);
        boolean result = saveOrUpdateBatch(riskLeclsConfDOList);
        riskLeclsConfDTOList = BeanHelper.listToList(riskLeclsConfDOList, TSafeRiskLeclsConfDTO.class);
        if(result) {
            return riskLeclsConfDTOList;
        }
        return null;
    }
    
    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    public List<TSafeRiskLeclsConfDTO> checkUniqueness(String leclsConfId, Integer type, String code){
        LambdaQueryWrapper<TSafeRiskLeclsConfDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeRiskLeclsConfDO::getStatus, BizConstants.STATUS_ENABLE)
                .eq(TSafeRiskLeclsConfDO::getCode, code) ;
        if(!StrUtil.isBlank(leclsConfId)) {
            queryWrapper.ne(TSafeRiskLeclsConfDO::getId, leclsConfId);
        }
        if(type != null) {
            queryWrapper.eq(TSafeRiskLeclsConfDO::getType, type);
        }
        List<TSafeRiskLeclsConfDO> pointDOList = tSafeRiskLeclsConfDao.selectList(queryWrapper);
        List<TSafeRiskLeclsConfDTO> pointDTOList = BeanHelper.listToList(pointDOList, TSafeRiskLeclsConfDTO.class);
        return pointDTOList;
    }
}

