package com.testor.ddd.safetyControl.infrastructure.repository.riskSource.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.riskSource.entity.TSafeRiskSourceRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskSource.dao.TSafeRiskSourceDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskSource.entity.TSafeRiskSourceDO;
import com.testor.ddd.safetyControl.infrastructure.uitls.RiskRelationTypeEnum;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskSourceServiceImpl extends SuperServiceImpl<TSafeRiskSourceDao, TSafeRiskSourceDO>
        implements TSafeRiskSourceRepo // ,TSafeRiskSourceService

{
    @Autowired(required = false)
    private TSafeRiskSourceDao tSafeRiskSourceDao;

    public TSafeRiskSourceDTO insert(TSafeRiskSourceDTO riskSourceDTO){
        TSafeRiskSourceDO data = BeanHelper.beanToBean(riskSourceDTO, TSafeRiskSourceDO.class);
        int result = tSafeRiskSourceDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskSourceDTO = BeanHelper.beanToBean(data, TSafeRiskSourceDTO.class);
        return riskSourceDTO;
    }

    public TSafeRiskSourceDTO updateById(TSafeRiskSourceDTO riskSourceDTO){
        TSafeRiskSourceDO data = BeanHelper.beanToBean(riskSourceDTO, TSafeRiskSourceDO.class);
        int result = tSafeRiskSourceDao.updateById(data);
        if(result < 1) {
            return null;
        }
        riskSourceDTO = BeanHelper.beanToBean(data, TSafeRiskSourceDTO.class);
        return riskSourceDTO;
    }

    /**
     * 分页查询
     * @param param
     * @return
     */
    public BaseResponseList<TSafeRiskSourceVO> listPage(TSafeRiskSourceDTOParam param){
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskSourceVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskSourceVO> iPage = tSafeRiskSourceDao.listPage(resultPage, param);

        BaseResponseList<TSafeRiskSourceVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }

    public TSafeRiskSourceDTO findById(String id){
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskSourceDO riskSourceDo = tSafeRiskSourceDao.selectById(id);
        TSafeRiskSourceDTO riskSourceDTO = BeanHelper.beanToBean(riskSourceDo, TSafeRiskSourceDTO.class);
        return riskSourceDTO;
    }

    public boolean deleteById(String id){
        UpdateWrapper<TSafeRiskSourceDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskSourceDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskSourceDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskSourceDO::getId,id);
        return update(updateWrapper);
    }

    /**
     *
     * @param type 1-设备; 2-空间(作业区域)；  3-空间(车间场所)；
     * @param bizId type=1-设备id; 2-空间(作业区域)id；  3-空间(车间场所)id；
     * @return
     */
    public boolean deleteBySpaceOrEquipment(Integer type, String bizId){
        if((type != 1 && type != 2 && type != 3)
        || StrUtil.isBlank(bizId)) {
            return false;
        }
        LambdaUpdateWrapper<TSafeRiskSourceDO> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(TSafeRiskSourceDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskSourceDO::getStatus, BizConstants.STATUS_DELETE);
        if(type == 1) {
            updateWrapper.eq(TSafeRiskSourceDO::getRelationType, RiskRelationTypeEnum.equipment.getCode())
                    .eq(TSafeRiskSourceDO::getRelationEquipmentId, bizId);
        }
        if(type == 2) {
            updateWrapper.eq(TSafeRiskSourceDO::getRelationType, RiskRelationTypeEnum.space.getCode())
                    .eq(TSafeRiskSourceDO::getRelationSpaceId, bizId);
        }
        if(type == 3) {
            updateWrapper.eq(TSafeRiskSourceDO::getRelationType, RiskRelationTypeEnum.space.getCode())
                    .eq(TSafeRiskSourceDO::getRelationSpaceParentId, bizId);
        }
        return update(updateWrapper);
    }

    public List<TSafeRiskSourceDTO> listAllEntity(TSafeRiskSourceDTOParam param){
        QueryWrapper<TSafeRiskSourceDO> queryWrapper=this.createQuery(param);
        List<TSafeRiskSourceDO> resultList=list(queryWrapper);
        List<TSafeRiskSourceDTO> resultDTOList= BeanHelper.listToList(resultList, TSafeRiskSourceDTO.class);
        return resultDTOList;
    }


    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeRiskSourceDO> createQuery(TSafeRiskSourceDTOParam queryParam){
        QueryWrapper<TSafeRiskSourceDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TSafeRiskSourceDO.ORG_ID,queryParam.getOrgId());
        }
        if(StringHelper.isNotEmpty(queryParam.getDepartmentId())){
            queryWrapper.eq(TSafeRiskSourceDO.DEPARTMENT_ID,queryParam.getDepartmentId());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSafeRiskSourceDO.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getCode())){
            queryWrapper.eq(TSafeRiskSourceDO.CODE,queryParam.getCode());
        }
        if(StringHelper.isNotEmpty(queryParam.getProcesses())){
            queryWrapper.eq(TSafeRiskSourceDO.PROCESSES,queryParam.getProcesses());
        }
        if(StringHelper.isNotEmpty(queryParam.getConsequenceId())){
            queryWrapper.eq(TSafeRiskSourceDO.CONSEQUENCE_ID,queryParam.getConsequenceId());
        }
        if(StringHelper.isNotEmpty(queryParam.getTypeId())){
            queryWrapper.eq(TSafeRiskSourceDO.TYPE_ID,queryParam.getTypeId());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getRelationType())){
            queryWrapper.eq(TSafeRiskSourceDO.RELATION_TYPE,queryParam.getRelationType());
        }
        if(StringHelper.isNotEmpty(queryParam.getRelationEquipmentId())){
            queryWrapper.eq(TSafeRiskSourceDO.RELATION_EQUIPMENT_ID,queryParam.getRelationEquipmentId());
        }
        if(StringHelper.isNotEmpty(queryParam.getRelationSpaceId())){
            queryWrapper.eq(TSafeRiskSourceDO.RELATION_SPACE_ID,queryParam.getRelationSpaceId());
        }
        if(StringHelper.isNotEmpty(queryParam.getSpaceLocation())){
            queryWrapper.eq(TSafeRiskSourceDO.SPACE_LOCATION,queryParam.getSpaceLocation());
        }
        if(StringHelper.isNotEmpty(queryParam.getIsMajor())){
            queryWrapper.eq(TSafeRiskSourceDO.IS_MAJOR,queryParam.getIsMajor());
        }
        if(StringHelper.isNotEmpty(queryParam.getRiskLevelId())){
            queryWrapper.eq(TSafeRiskSourceDO.RISK_LEVEL_ID,queryParam.getRiskLevelId());
        }
        if(StringHelper.isNotEmpty(queryParam.getInherentLevelId())){
            queryWrapper.eq(TSafeRiskSourceDO.INHERENT_LEVEL_ID,queryParam.getInherentLevelId());
        }
        if(StringHelper.isNotEmpty(queryParam.getRealLevelId())){
            queryWrapper.eq(TSafeRiskSourceDO.REAL_LEVEL_ID,queryParam.getRealLevelId());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getLecL())){
            queryWrapper.eq(TSafeRiskSourceDO.LEC_L,queryParam.getLecL());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getLecE())){
            queryWrapper.eq(TSafeRiskSourceDO.LEC_E,queryParam.getLecE());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getLecC())){
            queryWrapper.eq(TSafeRiskSourceDO.LEC_C,queryParam.getLecC());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getLsL())){
            queryWrapper.eq(TSafeRiskSourceDO.LS_L,queryParam.getLsL());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getLsS())){
            queryWrapper.eq(TSafeRiskSourceDO.LS_S,queryParam.getLsS());
        }
        if(StringHelper.isNotEmpty(queryParam.getControlLevelId())){
            queryWrapper.eq(TSafeRiskSourceDO.CONTROL_LEVEL_ID,queryParam.getControlLevelId());
        }
        if(StringHelper.isNotEmpty(queryParam.getControlStatusId())){
            queryWrapper.eq(TSafeRiskSourceDO.CONTROL_STATUS_ID,queryParam.getControlStatusId());
        }
        if(StringHelper.isNotEmpty(queryParam.getCheckFrequencyId())){
            queryWrapper.eq(TSafeRiskSourceDO.CHECK_FREQUENCY_ID,queryParam.getCheckFrequencyId());
        }
        if(StringHelper.isNotEmpty(queryParam.getControlBasis())){
            queryWrapper.eq(TSafeRiskSourceDO.CONTROL_BASIS,queryParam.getControlBasis());
        }
        if(StringHelper.isNotEmpty(queryParam.getControlMeasures())){
            queryWrapper.eq(TSafeRiskSourceDO.CONTROL_MEASURES,queryParam.getControlMeasures());
        }
        if(StringHelper.isNotEmpty(queryParam.getImprovementPlan())){
            queryWrapper.eq(TSafeRiskSourceDO.IMPROVEMENT_PLAN,queryParam.getImprovementPlan());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeRiskSourceDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeRiskSourceDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeRiskSourceDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

//    public boolean saveBatch(List<TSafeRiskSourceDTO> riskSourceDTOList){
//        List<TSafeRiskSourceDO> riskSourceDOList = BeanHelper.listToList(riskSourceDTOList, TSafeRiskSourceDO.class);
//        return saveBatch(riskSourceDOList);
//    }

    /**
     * 根据id查看详情
     * @param id
     * @return
     */
    public TSafeRiskSourceVO findDetailById(String id) {
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskSourceDTOParam param = new TSafeRiskSourceDTOParam();
        param.setStatus(BizConstants.STATUS_ENABLE);
        param.setPage("1");
        param.setLimit("1");
        param.setId(id);

        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskSourceVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskSourceVO> iPage = tSafeRiskSourceDao.listPage(resultPage, param);
        List<TSafeRiskSourceVO> riskSourceVOList = iPage.getRecords();
        if(riskSourceVOList == null || riskSourceVOList.size() == 0) {
            return null;
        }
        TSafeRiskSourceVO riskSourceVO = riskSourceVOList.get(0);
        return riskSourceVO;
    }

    /**
     * 列表不分页
     * @param param
     * @return
     */
    public List<TSafeRiskSourceDTO> listAll(TSafeRiskSourceDTOParam param){
        param.setStatus("0");
        QueryWrapper<TSafeRiskSourceDO> queryWrapper=this.createQuery(param);
        List<TSafeRiskSourceDO> resultList= this.list(queryWrapper);

        List<TSafeRiskSourceDTO> riskPointDTOList = BeanHelper.listToList(resultList, TSafeRiskSourceDTO.class);
        return riskPointDTOList;
    }

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    public List<TSafeRiskSourceDTO> checkUniqueness(String orgId, String sourceId, String name){
        LambdaQueryWrapper<TSafeRiskSourceDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeRiskSourceDO::getOrgId, orgId)
                .eq(TSafeRiskSourceDO::getStatus, BizConstants.STATUS_ENABLE)
               .eq(TSafeRiskSourceDO::getName, name) ;
        if(!StrUtil.isBlank(sourceId)) {
            queryWrapper.ne(TSafeRiskSourceDO::getId, sourceId);
        }
        List<TSafeRiskSourceDO> sourceDOList = tSafeRiskSourceDao.selectList(queryWrapper);
        List<TSafeRiskSourceDTO> sourceDTOList = BeanHelper.listToList(sourceDOList, TSafeRiskSourceDTO.class);
        return sourceDTOList;
    }

    /**
     * 危险源导出数据列表
     *
     * @param param
     * @return
     */
    @Override
    public List<TSafeRiskSourceVO> listExpData(TSafeRiskSourceDTOParam param) {
        return tSafeRiskSourceDao.listExpData(param);
    }
}

