package com.testor.ddd.safetyControl.infrastructure.uitls;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.application.service.equipmentManage.EquipmentTypeManageService;
import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceManageService;
import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceTypeManageService;
import com.testor.ddd.safetyControl.infrastructure.client.funConfClient.TableNumClient;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTO;
import com.testor.module.notice.model.domain.TSysOrg;
import com.testor.module.notice.service.TSysOrgService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 生成编码
 */
@Service
public class GenerateCode {

    @Resource
    private TSysOrgService sysOrgService;

    @Resource
    private TableNumClient tableNumClient;

    @Resource
    private SpaceManageService spaceManageService;

    @Resource
    private SpaceTypeManageService spaceTypeManageService;

    @Resource
    private EquipmentTypeManageService equipmentTypeManageService;

    /**
     * 组装生成 空间 的 fieldName
     * @param spaceDto
     * @return
     */
    public String generateSpaceTableNumFieldName(TSafeSpaceDTO spaceDto) {
        String fieldName = null;
        if(spaceDto.getLevel() == 1) {
            String orgId = spaceDto.getOrgId();
            TSysOrg sysOrg = sysOrgService.getById(orgId);
            String orgCode = sysOrg.getOrgCode();

            // todo 根据 spaceTypeId 查询 spaceType的编码，
            // spaceType功能暂未开发，用以下字符串代替
            TSafeSpaceTypeDTO spaceTypeDto = spaceTypeManageService.findById(spaceDto.getSpaceTypeId());
            String spaceTypeCode = spaceTypeDto.getCode();

            StringBuilder strB = new StringBuilder();
            strB.append(orgCode);
            strB.append("-");
            strB.append(spaceTypeCode);

            fieldName = strB.toString();
        }  if(spaceDto.getLevel() == 2) {
            String spaceId = spaceDto.getSpaceId();
            TSafeSpaceDTO spaceDTO = spaceManageService.findById(spaceId);
            fieldName = spaceDTO.getCode();
        }
        return fieldName;
    }

    /**
     * 通过 fieldName 生成 空间编码
     * @param fieldName
     * @return
     */
    public String generateCodeByFieldName(String tableName, String fieldName) {
        if(StrUtil.isBlank(fieldName)) {
            return null;
        }
        Integer maxNum = tableNumClient.obtainMaxNum(tableName, fieldName);
        StringBuilder strB = new StringBuilder();
        strB.append(fieldName);
        strB.append("-");
        strB.append(maxNum == null ?  "1" : String.valueOf(maxNum+1));
        return strB.toString();
    }

//    /**
//     * 生成车间场所编码
//     */
//    public String generateWorkshopCode(String orgId, String spaceTypeId) {
//        TSysOrg sysOrg = sysOrgService.getById(orgId);
//        String orgCode = sysOrg.getOrgCode();
//        // todo 根据 spaceTypeId 查询 spaceType的编码，
//        // spaceType功能暂未开发，用以下字符串代替
//        String spaceTypeCode = "testSpaceTypeCode";
//
//        StringBuilder strB = new StringBuilder();
//        strB.append(orgCode);
//        strB.append("-");
//        strB.append(spaceTypeCode);
//        Integer maxNum = tableNumClient.obtainMaxNum("t_safe_space", strB.toString());
//
//        strB.append("-");
//        strB.append(maxNum == null ? "1" : String.valueOf(maxNum+1));
//        return strB.toString();
//    }
//
//    /**
//     * 生成作业区域编码
//     */
//    public String generateWorkareaCode(String spaceTypeId) {
//        TSafeSpaceDTO spaceDTO = spaceManageService.findById(spaceTypeId);
//        String workshopCode = spaceDTO.getCode();
//        Integer maxNum = tableNumClient.obtainMaxNum("t_safe_space", workshopCode);
//        StringBuilder strB = new StringBuilder();
//        strB.append(workshopCode);
//        strB.append("-");
//        strB.append(maxNum == null ?  "1" : String.valueOf(maxNum+1));
//        return strB.toString();
//    }

    /**
     * 组装生成 空间 的 fieldName
     * @param equipmentDTO
     * @return
     */
    public String generateEquipmentTableNumFieldName(TSafeEquipmentDTO equipmentDTO) {
        String orgId = equipmentDTO.getOrgId();
        TSysOrg sysOrg = sysOrgService.getById(orgId);
        String orgCode = sysOrg.getOrgCode();
        StringBuilder strB = new StringBuilder();
        strB.append(orgCode);

        String equipmentTypeStr = equipmentDTO.getEquipmentTypeId();
        String sysTypeStr = equipmentDTO.getSysTypeId();
        // 根据 sysTypeId 查询 sysType的编码，
        if(!StrUtil.isBlank(sysTypeStr)) {
            TSafeEquipmentTypeDTO equipmentSysTypeDTO = equipmentTypeManageService.findById(equipmentDTO.getSysTypeId());
            String sysTypeCode = equipmentSysTypeDTO.getCode();
            strB.append("-");
            strB.append(sysTypeCode);
        }

        // 根据 equipmentTypeId 查询 equipmentType的编码，
        if(!StrUtil.isBlank(equipmentTypeStr)) {
            TSafeEquipmentTypeDTO equipmentTypeDTO = equipmentTypeManageService.findById(equipmentDTO.getEquipmentTypeId());
            String equipmentTypeCode = equipmentTypeDTO.getCode();
            strB.append("-");
            strB.append(equipmentTypeCode);
        }

        String fieldName = strB.toString();
        return fieldName;
    }

}
