package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.equipmentManage.EquipmentManageService;
import com.testor.ddd.safetyControl.domain.equipment.entity.TSafeEquipmentRepo;
import com.testor.ddd.safetyControl.infrastructure.uitls.EquipmentExcelTemplate.SpaceExcelTemplate.DownloadEquipmentTemplateUtil;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDelParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.EquipmentStatisticsVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 空间设备Controller
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:19
 */
@RestController
@RequestMapping("/equipment/equipment")
@Api(value = "TSafeEquipment", tags = "设备")
@Slf4j
public class TSafeEquipmentController extends SuperController {
    @Resource
    private EquipmentManageService equipmentManageService;

    @Autowired
    private TSafeEquipmentRepo tSafeEquipmentRepo;

    @Autowired
    private DownloadEquipmentTemplateUtil downloadEquipmentTemplateUtil;

    /* Generated Method*/
    @ApiOperation(value = "新增、修改设备", notes = "Add TSafeEquipment")
    @PostMapping(value = "/add")
    public BaseResponse addEntity(@RequestBody TSafeEquipmentDTO addRequest) {
        return equipmentManageService.editEquipment(addRequest);
    }

    @ApiOperation(value = "删除 设备 ", notes = "delete TSafeEquipment By Id")
    @PutMapping(value = "/delete")
    public BaseResponse deleteEntity(@RequestBody TSafeEquipmentDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            baseResponse = equipmentManageService.deleteById(deleteRequest.getId());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 设备 分页列表", notes = "List TSafeEquipment with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TSafeEquipmentVO>> listEntity(TSafeEquipmentDTOParam param) {
        BaseResponse<BaseResponseList<TSafeEquipmentVO>> baseResponse = new BaseResponse<>();
        param.setOrderBy("se.create_date");
        param.setOrderType("desc");
        BaseResponseList<TSafeEquipmentVO> resultList = tSafeEquipmentRepo.listPage(param);
        baseResponse.setData(resultList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 设备 详情 ", notes = "Get TPartnerOrg By Id")
    @GetMapping(value = "/findDetailById")
    public BaseResponse<TSafeEquipmentVO> findDetailById(String id) {
        BaseResponse<TSafeEquipmentVO> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            TSafeEquipmentVO data = equipmentManageService.findDetailById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "统计设备信息 ")
    @GetMapping(value = "/statisticsEquipment")
    public BaseResponse<EquipmentStatisticsVO> statisticsEquipment(String orgId) {
        BaseResponse<EquipmentStatisticsVO> baseResponse = new BaseResponse<>();
        EquipmentStatisticsVO data = equipmentManageService.statisticsEquipment(orgId);
        baseResponse.setData(data);
        return baseResponse;
    }

    @ApiOperation(value = "下载设备导入模板（设备信息批量导入模板-使用_1657247522874.xlsx）")
    @GetMapping(value = "/downloadEquipmentTemplate")
    public void downloadEquipmentTemplate(HttpServletResponse response, String fileDowName) {
        UserInfo curUser = ContextUtils.getLoginUser();
        String curUserOrgId = curUser.getOrgId();
        downloadEquipmentTemplateUtil.downloadEquipmentTemplate(response, fileDowName, curUserOrgId);
    }

    @ApiOperation(value = "导入设备", notes = "")
    @PostMapping("/importEquipment")
    public BaseResponse<String> importEquipment(@RequestParam("file") MultipartFile file) throws Exception {
        return equipmentManageService.importEquipment(file);
    }

    @ApiOperation(value = "设备列表 （安全风险 拉下数据）", notes = "List TSafeEquipment with page")
    @GetMapping(value = "/listForRisk")
    public BaseResponse<List<TSafeEquipmentVO>> listForRisk(TSafeEquipmentDTOParam param) {
        BaseResponse<List<TSafeEquipmentVO>> baseResponse = new BaseResponse<>();
        List<TSafeEquipmentVO> resultList = equipmentManageService.listForRisk(param);
        baseResponse.setData(resultList);
        return baseResponse;
    }
}
