package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.riskLeclsManage.RiskLeclsManageService;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.*;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 危险源Controller
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@RestController
@RequestMapping("/risk/lecls")
@Api(value = "TSafeRiskLecls", tags = "lecls")
@Slf4j
public class TSafeRiskLeclsController extends SuperController
{
    @Autowired
    private RiskLeclsManageService riskLeclsManageService;

	/* Generated Method*/
	@ApiOperation(value = "新增、修改lecls 配置数据", notes = "Add TSafeRiskLecls")
	@PostMapping(value = "/addConf")
	public BaseResponse addConf(@RequestBody TSafeRiskLeclsConfAddDTO addRequest) throws BusinessException {
		return riskLeclsManageService.editRiskLeclsConf(addRequest.getConfDTOList());
	}

	@ApiOperation(value = "删除 lecls 配置数据 ", notes = "delete TSafeRiskLecls By Id")
	@PutMapping(value = "/deleteConf")
	public BaseResponse deleteConf(@RequestBody TSafeRiskLeclsConfDelParam deleteRequest) throws BusinessException {
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
			baseResponse= riskLeclsManageService.deleteById(deleteRequest.getId());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 lecls 配置数据 列表", notes = "List TSafeRiskLecls")
	@PostMapping(value = "/listConf")
	public  BaseResponse<List<TSafeRiskLeclsConfDTO>>listConf(@RequestBody TSafeRiskLeclsConfDTOParam param){
		BaseResponse<List<TSafeRiskLeclsConfDTO>>baseResponse=new BaseResponse<>();
		List<TSafeRiskLeclsConfDTO> resultList= riskLeclsManageService.listAllEntity(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}


	@ApiOperation(value = "获取 lecls 配置数据 详情 ", notes = "Get TSafeRiskLecls By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeRiskLeclsConfDTO> getById(String id){
		BaseResponse<TSafeRiskLeclsConfDTO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			TSafeRiskLeclsConfDTO data= riskLeclsManageService.findById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	/* Generated Method*/
	@ApiOperation(value = "新增、修改lecls 现实风险关联数据", notes = "Add TSafeRiskLecls")
	@PostMapping(value = "/addRelation")
	public BaseResponse addRelation(@RequestBody TSafeRiskLeclsRelationAddDTO addRequest) throws BusinessException {
		return riskLeclsManageService.editRiskLeclsRelation(addRequest.getRelationDTOList());
	}

	@ApiOperation(value = "删除 lecls 现实风险关联数据(通过id) ", notes = "delete TSafeRiskLecls By Id")
	@PutMapping(value = "/deleteRelation")
	public BaseResponse deleteRelation(@RequestBody TSafeRiskLeclsRelationDelParam deleteRequest) throws BusinessException {
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
			baseResponse= riskLeclsManageService.deleteRelationById(deleteRequest.getId());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 lecls 现实风险关联数据（通过类型）", notes = "delete TSafeRiskLecls By Id")
	@GetMapping(value = "/deleteRelationByType")
	public BaseResponse deleteRelationByType(Integer type) throws BusinessException {
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		baseResponse= riskLeclsManageService.deleteRelationByType(type);
		return baseResponse;
	}

	@ApiOperation(value = "获取 lecls 现实风险关联数据 列表", notes = "List TSafeRiskLecls")
	@PostMapping(value = "/listRelation")
	public  BaseResponse<List<TSafeRiskLeclsRelationDTO>>listRelation(@RequestBody TSafeRiskLeclsRelationDTOParam param){
		BaseResponse<List<TSafeRiskLeclsRelationDTO>>baseResponse=new BaseResponse<>();
		List<TSafeRiskLeclsRelationDTO> resultList= riskLeclsManageService.listRelationAllEntity(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}


	@ApiOperation(value = "获取 lecls 现实风险关联数据 详情 ", notes = "Get TSafeRiskLecls By Id")
	@GetMapping(value = "/getRelation")
	public BaseResponse<TSafeRiskLeclsRelationDTO> getRelationById(String id){
		BaseResponse<TSafeRiskLeclsRelationDTO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			TSafeRiskLeclsRelationDTO data= riskLeclsManageService.findRelationById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "根据 lecls 计算获取 危险等级及管控信息 ")
	@PostMapping(value = "/findLevelRelation")
	public BaseResponse<TSafeRiskRealLevelRelationDTO> findLevelRelation(@RequestBody RiskLeclsValDTO riskLeclsValDTO) throws BusinessException{
		BaseResponse<TSafeRiskRealLevelRelationDTO> baseResponse=new BaseResponse<>();
		TSafeRiskRealLevelRelationDTO data= riskLeclsManageService.findLevelByLecls(riskLeclsValDTO);
		baseResponse.setData(data);
		return baseResponse;
	}
}
