package com.testor.ddd.safetyControl.interfaces.model.dto.equipment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 空间设备对象 t_safe_equipment
 * 
 * @author testor-framework
 * @date 2022-06-27 16:56:19
 */
@Data
public class TSafeEquipmentDTO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;

  @ApiModelProperty(value = "系统类型(编辑必填)")
  private String sysTypeId;

  @ApiModelProperty(value = "设备类型(编辑必填)")
  private String equipmentTypeId;

  @ApiModelProperty(value = "名称(编辑必填)")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码(编辑必填)")
  private String code;

  /**
   * 照片路径
   */
  @ApiModelProperty(value = "照片路径(编辑必填)")
  private String imgUrl;

/**
 * 规格型号
 */
  @ApiModelProperty(value = "规格型号")
  private String specification;
/**
 * 车间场所id(space表 level=1)
 */
  @ApiModelProperty(value = "车间场所id(编辑必填)")
  private String spaceId;

/**
 * 作业区域id(space表 level=2)
 */
  @ApiModelProperty(value = "作业区域id(编辑必填)")
  private String spaceAreaId;

/**
 * 生产厂商
 */
  @ApiModelProperty(value = "生产厂商")
  private String manufacturer;
/**
 * 描述
 */
  @ApiModelProperty(value = "描述")
  private String des;

  @ApiModelProperty(value = "有效期限(isSpecial=1 时 编辑必填)")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validityDate;

  @ApiModelProperty(value = " 是否特种设备 0-否；1-是（编辑必填）")
  private String isSpecial;

}
