package com.testor.ddd.safetyControl.interfaces.model.dto.equipment;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 空间设备 删除参数对象
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:19
 */

@Data
@ApiModel(value = "TSafeEquipment 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeEquipmentDTOParam extends TSafeEquipmentDTO {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "企业选择")
	private List<String> condOrgIdList;

	@ApiModelProperty(value = "选择的系统类型")
	private List<String> condSysTypeIdList;

	@ApiModelProperty(value = "选择的设备类型")
	private List<String> condEquipmentTypeIdList;

	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "有效期限-开始日期(格式 2022-07-01 00:00:00)")
	private Date validityStartDate;

	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "有效期限-结束日期（格式：2022-07-01 23:59:59）")
	private Date validityEndDate;
}
