package com.testor.ddd.safetyControl.interfaces.model.dto.riskSource;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskOwner.TSafeRiskOwnerDTO;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Size;
import java.util.List;


/**
 * 危险源对象 t_safe_risk_source
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Data
public class TSafeRiskSourceDTO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;

  @ApiModelProperty(value = "组织结构完整路径(到部门)")
  private String orgAllPath;

/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;

  @ApiModelProperty(value = "区域公司id")
  private String regionOrgId;

/**
 * 部门id
 */
  @ApiModelProperty(value = "部门id(编辑必填)")
  private String departmentId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称(编辑必填)")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码(编辑不填)")
  private String code;
/**
 * 工序工艺
 */
  @ApiModelProperty(value = "工序工艺")
  private String processes;
/**
 * 可能导致的后果(关联字典表id)
 */
  @ApiModelProperty(value = "可能导致的后果(关联字典表id,多个英文,分割)(编辑必填)")
  private String consequenceId;
/**
 * 危险源类型(关联字典表id)
 */
  @ApiModelProperty(value = "危险源类型(关联字典表id)(编辑必填)")
  private String typeId;
/**
 * 危险源关联类型(1-设备；2-空间)
 */
  @ApiModelProperty(value = "危险源关联类型(1-设备；2-空间)(编辑必填)" , example = "0")
  private Integer relationType;
/**
 * 关联设备id
 */
  @ApiModelProperty(value = "关联设备id")
  private String relationEquipmentId;


  /**
   * 关联空间id(作业区域)
   */
  @ApiModelProperty(value = "关联空间id(车间场所，作业区域父级)")
  private String relationSpaceParentId;
/**
 * 关联空间id(作业区域)
 */
  @ApiModelProperty(value = "关联空间id(作业区域)")
  private String relationSpaceId;
/**
 * 空间位置
 */
  @ApiModelProperty(value = "空间位置(编辑不填)")
  private String spaceLocation;
/**
 * 是否为重大危险源(0-否，1是)
 */
  @ApiModelProperty(value = "是否为重大危险源(0-否，1是)")
  private String isMajor;
/**
 * 危险等级(关联字典表id)
 */
  @ApiModelProperty(value = "危险等级(关联字典表id)")
  private String riskLevelId;
/**
 * 固有风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)(编辑必填)")
  private String inherentLevelId;
/**
 * 现实风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)(编辑必填)")
  private String realLevelId;

  @ApiModelProperty(value = "现实风险辨识方法  1-lec; 2-ls")
  private Integer identificationMethod;

  private Float lecL;

  private Float lecE;

  private Float lecC;

  private Float lsL;

  private Float lsS;
/**
 * 管控层级(关联字典表id)
 */
  @ApiModelProperty(value = "管控层级(关联字典表id)(编辑必填)")
  private String controlLevelId;
/**
 * 管控状态(关联字典表id)
 */
  @ApiModelProperty(value = "管控状态(关联字典表id)(编辑必填)")
  private String controlStatusId;
/**
 * 检查频次(关联字典表id)
 */
  @ApiModelProperty(value = "检查频次(关联字典表id)(编辑必填)")
  private String checkFrequencyId;
/**
 * 控制依据
 */
  @ApiModelProperty(value = "控制依据(编辑必填)")
  @Size(max = 3000,message = "控制依据超出限制")
  private String controlBasis;
/**
 * 管控措施
 */
  @ApiModelProperty(value = "管控措施(编辑必填)")
  @Size(max = 3000,message = "管控措施超出限制")
  private String controlMeasures;

  @ApiModelProperty(value = "进一步管控措施")
  private String furtherControlMeasures;
/**
 * 改进措施
 */
  @ApiModelProperty(value = "改进措施")
  @Size(max = 3000,message = "改进措施超出限制")
  private String improvementPlan;

  @ApiModelProperty(value = "关联空间层级ids")
  private String relationSpaceLevelIds;

  @ApiModelProperty(value = "关联设备层级ids")
  private String relationEquipmentLevelIds;

  @ApiModelProperty(value = "是否被修改：0-未 1-修改")
  private String updated;

  @ApiModelProperty(value = "基层单位id")
  private String basicOrgId;

  @ApiModelProperty(value = "管控部门与责任人")
  private List<TSafeRiskOwnerDTO> riskOwnerList;

}
