package com.testor.module.ZLOA.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@Data
public class ZOrg {
        // 所属单位ID
        private String orgAccountId;
        private String id;
        // 单位名称
        private String name;
        // 单位编码
        private String code;
        // 排序号
        private Long sortId;
        // 单位简称
        private String shortName;
        // 创建时间

        @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        private Date createTime;
        // 修改时间

        @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
        @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        private Date updateTime;
        // 是否删除
        private Boolean isDeleted;
        // 是否启用
        private String enabled;
        // 状态
        private String status;
        // 描述
        private String description;
        // 路径
        private String path;
        // 外文名称
        private String secondName;
        // 是否是内部机构
        private String isInternal;
        // 是否是集团
        private Boolean isGroup;
        // 只对type=account有效
        private String levelScope;
        // 类型
        private String type;
        // 上级单位Id，如果当前单位为集团则值为-1
        private String superior;
        //
        private String superiorName;
        private String sortIdType;
        // 是否可访问
        private String isCanAccess;
        //
        private String accessIds;
        private String accessScopeLevels;
        private String childrenAccounts;
        // 实体类型
        private String entityType;
        // 是否合法
        private String valid;
        private String group;
        private String customLogin;
        // 父单位路径
        private String parentPath;
        private String customLoginUrl;
        // 练习地址
        private String address;

        private String properties;
}
