package com.testor.module.aptitude.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 人员资质管理对象 t_person_aptitude
 * 
 * @author testor-framework
 * @date 2022-07-20 18:05:48
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_person_aptitude")
@ApiModel(value = "TPersonAptitude对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TPersonAptitude extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 人员姓名
 */
  @ApiModelProperty(value = "人员姓名")

  @TableField("person_name")
  private String personName;
/**
 * 人员id
 */
  @ApiModelProperty(value = "人员id")

  @TableField("person_id")
  private String personId;
/**
 * 部门id
 */
  @ApiModelProperty(value = "部门id")

  @TableField("dept_id")
  private String deptId;
/**
 * 资质名称
 */
  @ApiModelProperty(value = "资质名称")

  @TableField("aptitude_name")
  private String aptitudeName;
/**
 * 资质状态 0 全部 1有效 2 失效
 */
  @ApiModelProperty(value = "资质状态 0 全部 1有效 2 失效")

  @TableField("aptitude_status")
  private String aptitudeStatus;
/**
 * 注册/获评时间
 */
  @ApiModelProperty(value = "注册/获评时间")

  @TableField("register_data")
  private String registerData;
/**
 * 资质有效期限
 */
  @ApiModelProperty(value = "资质有效期限")

  @TableField("aptitude_valid")
  private String aptitudeValid;
/**
 * 资质是否长期有效 1 是 0 否
 */
  @ApiModelProperty(value = "资质是否长期有效 1 是 0 否")

  @TableField("is_long_time_valid")
  private String isLongTimeValid;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  @TableField(exist = false)
  private String businessOrgName;

  public static final String ID ="id";
  public static final String PERSON_NAME ="person_name";
  public static final String PERSON_ID ="person_id";
  public static final String DEPT_ID ="dept_id";
  public static final String APTITUDE_NAME ="aptitude_name";
  public static final String APTITUDE_STATUS ="aptitude_status";
  public static final String REGISTER_DATA ="register_data";
  public static final String APTITUDE_VALID ="aptitude_valid";
  public static final String IS_LONG_TIME_VALID ="is_long_time_valid";
  public static final String ORG_NAME ="org_name";
  public static final String PROCESS_STATUS ="process_status";
  public static final String REF_ID ="ref_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PARENT_ID ="parent_id";
  public static final String ORG_ID ="org_id";


}
