package com.testor.module.contractor.ledger.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import com.testor.module.contractor.ledger.model.domain.TContractorLedger;

/**
 * 承包商台账 删除参数对象
 *
 * @author testor-framework
 * @date 2024-11-19 10:01:42
 */

@Data
@ApiModel(value = "TContractorLedger 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContractorLedgerParam extends TContractorLedger {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "企业名称")
	private String name;

	@ApiModelProperty(value = "有效期限 between")
	private List<LocalDateTime> validPeriodBetween;

	@ApiModelProperty(value = "有效期限 起始时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	private String validPeriodStart;

	@ApiModelProperty(value = "有效期限 结束时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private String validPeriodEnd;

}
