package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.common.util.BeanConverUtil;
import com.testor.module.contractor.enums.GeneralFlagEnum;
import com.testor.module.contractor.ledger.model.domain.TContractorInfo;
import com.testor.module.contractor.ledger.model.domain.TContractorLedger;
import com.testor.module.contractor.ledger.model.domain.TContractorProject;
import com.testor.module.contractor.ledger.service.TContractorInfoService;
import com.testor.module.contractor.ledger.service.TContractorLedgerService;
import com.testor.module.contractor.ledger.service.TContractorProjectService;
import com.testor.module.contractor.manage.model.domain.TContractorAcceptanceChecklist;
import com.testor.module.contractor.manage.model.dto.TContractorAcceptanceDTO;
import com.testor.module.contractor.manage.service.TContractorAcceptanceChecklistService;
import com.testor.module.portal.context.ContextConstants;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorAcceptance;
import com.testor.module.contractor.manage.model.dto.TContractorAcceptanceParam;
import com.testor.module.contractor.manage.model.dto.TContractorAcceptanceDelParam;
import com.testor.module.contractor.manage.service.TContractorAcceptanceService;

/**
 * 承包商管理-验收交付Controller
 *
 * @author testor-framework
 * @date 2024-12-01 15:01:41
 */
@RestController
@RequestMapping("/manage/acceptance")
@Api(value = "TContractorAcceptance", tags = "承包商管理-验收交付")
@Slf4j
public class TContractorAcceptanceController extends SuperController
{
    @Autowired
    private TContractorAcceptanceService tContractorAcceptanceService;

	@Autowired
	private TContractorAcceptanceChecklistService tContractorAcceptanceChecklistService;

	@Autowired
	private TContractorProjectService tContractorProjectService;
	@Autowired
	private TContractorLedgerService tContractorLedgerService;
	@Autowired
	private TContractorInfoService tContractorInfoService;


	@ApiOperation(value = "新增 承包商管理-验收交付", notes = "Add TContractorAcceptance")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorAcceptance>addEntity(@RequestBody TContractorAcceptanceDTO addRequest) {
		BaseResponse<TContractorAcceptance> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			TContractorAcceptance result= tContractorAcceptanceService.addEntity(addRequest);
			baseResponse.setData(result);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-验收交付 ", notes = "Get TContractorAcceptance By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorAcceptanceDTO> getById(String id){
		BaseResponse<TContractorAcceptanceDTO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorAcceptance data= tContractorAcceptanceService.getById(id);
			TContractorAcceptanceDTO tContractorAcceptanceDTO = BeanConverUtil.conver(data, TContractorAcceptanceDTO.class);
			List<TContractorAcceptanceChecklist> tContractorAcceptanceChecklists = tContractorAcceptanceChecklistService.list(new LambdaQueryWrapper<>(TContractorAcceptanceChecklist.class).eq(TContractorAcceptanceChecklist::getAcceptId, id).orderByAsc(TContractorAcceptanceChecklist::getSortNo));
			TContractorLedger tContractorLedger = tContractorLedgerService.getById(tContractorAcceptanceDTO.getContractorId());
			if (tContractorLedger != null){
				TContractorInfo tContractorInfo = tContractorInfoService.getById(tContractorLedger.getInfoId());
				if (tContractorInfo != null){
					String contractorName = GeneralFlagEnum.YES.getCode().equals(tContractorInfo.getIsBlacklist()) ?
							StringHelper.format("{}（黑名单）", tContractorInfo.getName()) : tContractorInfo.getName();
					tContractorAcceptanceDTO.setContractorName(contractorName);
				}
			}
			TContractorProject tContractorProject = tContractorProjectService.getById(tContractorAcceptanceDTO.getProjId());
			if (tContractorProject!= null){
				tContractorAcceptanceDTO.setTContractorProject(tContractorProject);
			}
			tContractorAcceptanceDTO.setTContractorAcceptanceChecklists(tContractorAcceptanceChecklists);
			baseResponse.setData(tContractorAcceptanceDTO);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商管理-验收交付 ", notes = "Update TContractorAcceptance By Id")
	@PutMapping(value = "/update")
	public BaseResponse<TContractorAcceptance> updateEntity(@RequestBody TContractorAcceptanceDTO updateRequest){
		BaseResponse<TContractorAcceptance> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			TContractorAcceptance data = tContractorAcceptanceService.updateEntity(updateRequest);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商管理-验收交付 ", notes = "delete TContractorAcceptance By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorAcceptanceDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAcceptance data= new TContractorAcceptance();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorAcceptanceService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商管理-验收交付", notes = "delete TContractorAcceptance by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorAcceptanceDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorAcceptance> tContractorAcceptanceList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorAcceptance data= new TContractorAcceptance();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorAcceptanceList.add(data);
			}
			boolean result = tContractorAcceptanceService.updateBatchById(tContractorAcceptanceList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "提交", notes = "启动流程")
	@PostMapping(value = "/submit")
	public BaseResponse<BizGeneralResponse> submit(@RequestBody TContractorAcceptanceDTO tContractorAcceptanceDTO){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(tContractorAcceptanceDTO)&&StringHelper.isNotEmpty(tContractorAcceptanceDTO.getId())){
			tContractorAcceptanceService.submit(tContractorAcceptanceDTO);
		}
		return baseResponse;
	}

	@ApiOperation(value = "完成流程", notes = "完成流程 通过/驳回")
	@PostMapping(value = "/completeProcess")
	public BaseResponse<BizGeneralResponse> completeProcess(@RequestBody TContractorAcceptanceDTO tContractorAcceptanceDTO){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(tContractorAcceptanceDTO)&&StringHelper.isNotEmpty(tContractorAcceptanceDTO.getId())){
			tContractorAcceptanceService.completeProcess(tContractorAcceptanceDTO);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-验收交付 分页列表", notes = "List TContractorAcceptance with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorAcceptanceDTO>>listEntity(TContractorAcceptanceParam param){
		BaseResponse<BaseResponseList<TContractorAcceptanceDTO>>baseResponse=new BaseResponse<>();
		param.setOrgId(ContextUtils.getLoginUser().getOrgId());
		Page<TContractorAcceptanceDTO> resultList= tContractorAcceptanceService.listEntity(param);
		BaseResponseList<TContractorAcceptanceDTO> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-验收交付 列表", notes = "List TContractorAcceptance all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorAcceptance>>listAllEntity(TContractorAcceptanceParam param){
		BaseResponse<BaseResponseList<TContractorAcceptance>>baseResponse=new BaseResponse<>();
		List<TContractorAcceptance> resultList=tContractorAcceptanceService.listAllEntity(param);
		BaseResponseList<TContractorAcceptance> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

}
