package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.List;

import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 日常管理-每日工作计划-检查任务-检查结果对象 t_contractor_daily_plan_inspect_result
 * 
 * @author testor-framework
 * @date 2024-11-30 15:43:17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_daily_plan_inspect_result")
@ApiModel(value = "TContractorDailyPlanInspectResult对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorDailyPlanInspectResult extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 检查任务id
 */
  @ApiModelProperty(value = "检查任务id")

  @TableField("inspect_id")
  private String inspectId;
/**
 * 分类
 */
  @ApiModelProperty(value = "分类")

  @TableField("type")
  private String type;
/**
 * 检查项目
 */
  @ApiModelProperty(value = "检查项目")

  @TableField("inspect_item")
  private String inspectItem;
/**
 * 检查内容
 */
  @ApiModelProperty(value = "检查内容")

  @TableField("inspect_content")
  private String inspectContent;
/**
 * 是否合规 0否 1是 2不涉及
 */
  @ApiModelProperty(value = "是否合规 0否 1是 2不涉及")

  @TableField("if_comply")
  @Translation(other = "0=否,1=是,2=不涉及")
  private String ifComply;
/**
 * 问题描述
 */
  @ApiModelProperty(value = "问题描述")

  @TableField("problem")
  private String problem;
/**
 * 编号
 */
  @ApiModelProperty(value = "编号" , example = "0")

  @TableField("sort_no")
  private Long sortNo;

  @ApiModelProperty(value = "隐患ids")
  @TableField(exist = false)
  private List<String> hazardIds;

  public static final String ID ="id";
  public static final String INSPECT_ID ="inspect_id";
  public static final String TYPE ="type";
  public static final String INSPECT_ITEM ="inspect_item";
  public static final String INSPECT_CONTENT ="inspect_content";
  public static final String IF_COMPLY ="if_comply";
  public static final String PROBLEM ="problem";
  public static final String SORT_NO ="sort_no";


}
