package com.testor.module.duty.controller;


import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.testor.common.util.ExcelFillCellMergeStrategy;
import com.testor.module.duty.model.domain.TSysDuty;
import com.testor.module.duty.model.domain.TSysDutyMonth;
import com.testor.module.duty.model.domain.TSysDutyalter;
import com.testor.module.duty.model.dto.Duty;
import com.testor.module.duty.model.dto.DutyAlter;
import com.testor.module.duty.model.dto.Person;
import com.testor.module.duty.model.po.ExportDutyPo;
import com.testor.module.duty.model.po.ExportPo;
import com.testor.module.duty.service.DutyService;
import com.testor.module.duty.service.TSysDutyMonthService;
import com.testor.module.duty.service.TSysDutyalterService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;

@RestController
@RequestMapping("/duty")
@Slf4j
@Api(value = "duty", tags = "值班值守模块")
public class DutyController {
    @Autowired
    private DutyService dutyService;
    @Autowired
    private TSysDutyalterService tSysDutyalterService;
    @Autowired
    private TSysDutyMonthService tSysDutyMonthService;

    @ApiOperation(value = "获取首页值班值守信息")
    @GetMapping("/getHomeDuty")
    public BaseResponse<List<TSysDuty>> getHomeDuty(String orgId) {
        return dutyService.getHomeDuty(orgId);
    }

    @ApiOperation(value = "添加整月数据", notes = "")
    @PostMapping("/add")
    public BaseResponse add(@RequestBody List<Duty> duty) throws Exception {
        return dutyService.add(duty);
    }

    @ApiOperation(value = "单个添加值班人员", notes = "")
    @PostMapping("/insert")
    public BaseResponse inserts(@RequestBody TSysDuty tSysDuty) throws Exception {
        return dutyService.inserts(tSysDuty);
    }

    //    @ApiOperation(value = "修改值班人员 审核通过列表数据更新", notes = "修改完之后返回新数据的id ")
//    @PostMapping("/update")
//    public BaseResponse update(@RequestBody TSysDuty tSysDuty) throws Exception {
//        return dutyService.update(tSysDuty);
//    }
    @ApiOperation(value = "修改值班人员 ", notes = " ")
    @PostMapping("/update")
    public BaseResponse update(@RequestBody TSysDuty tSysDuty) throws Exception {
        return dutyService.updateByDuty(tSysDuty);
    }

    //    @ApiOperation(value = "删除和修改 审核状态修改接口" , notes = "删除和修改的数据在审核中修改状态")
//    @PostMapping("/auditUpdate")
    public BaseResponse auditUpdate(@RequestBody TSysDutyalter tSysDutyalter) throws Exception {
        return dutyService.auditUpdate(tSysDutyalter);
    }

    @ApiOperation(value = "删除值班人员", notes = "")
    @PostMapping("/delete")
    public BaseResponse delete(@RequestBody TSysDuty tSysDuty) throws Exception {
        return dutyService.delete(tSysDuty);
    }

    @ApiOperation(value = "获取整月日历数据", notes = "")
    @PostMapping("/list")
    public BaseResponse<List<Duty>> getLists(@RequestBody TSysDutyMonth tSysDutyMonth) throws Exception {
        BaseResponse<List<Duty>> list = dutyService.getLists(tSysDutyMonth);
        return list;
    }

    @ApiOperation(value = "批量导入值班人员本单位", notes = "")
    @PostMapping("/import")
    public BaseResponse<List<Person>> imports(@RequestParam("file") MultipartFile file, TSysDuty tSysDuty) throws Exception {
        return dutyService.imports(file, tSysDuty);
    }

    @ApiOperation(value = "值班修改记录", notes = "")
    @PostMapping("/getAmendRec")
    public BaseResponse<BaseResponseList<TSysDutyalter>> getAmendRec(@RequestBody DutyAlter dutyAlter) throws Exception {
        return tSysDutyalterService.getAmendRec(dutyAlter);
    }


    @SneakyThrows
    @ApiOperation(value = "下载值班记录", notes = "")
    @PostMapping("/downloadDutyLog")
    public void downloadDutyLog(@RequestBody TSysDutyMonth tSysDutyMonth, HttpServletResponse response){
        List<ExportPo> exportPo = dutyService.downloadDutyLog(tSysDutyMonth);
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("值班记录", "utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        response.addHeader("Pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        InputStream templatePathName = this.getClass().getClassLoader().getResourceAsStream("excel/zbxxdc.xlsx");
        ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).registerWriteHandler(
                new ExcelFillCellMergeStrategy(1,new int[]{0,1,3,4})
        ).withTemplate(templatePathName).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
        // 直接写入数据
        excelWriter.fill(exportPo, fillConfig, writeSheet);
        excelWriter.finish();
    }



    @SneakyThrows
    @ApiOperation(value = "下载值班日历", notes = "")
    @PostMapping("/exportDuty")
    public void exportDuty(@RequestBody TSysDutyMonth tSysDutyMonth ,HttpServletResponse response){
        dutyService.exportDuty(tSysDutyMonth,response);
    }


    @ApiOperation(value = "编辑值班模式", notes = "")
    @PostMapping("/editDutyPattern")
    public BaseResponse editDutyPattern(@RequestBody TSysDutyMonth tSysDutyMonth) throws Exception {
        return tSysDutyMonthService.editDutyPattern(tSysDutyMonth);
    }

    //    @ApiOperation(value = "编辑的时候数据回显", notes = "")
//    @PostMapping("/auditEcho")
    public BaseResponse auditEcho(@RequestBody Person person) throws Exception {
        return dutyService.auditEcho(person);
    }

    //    @ApiOperation(value = "值班列表单个添加人审批状态修改")
//    @PostMapping("/dutyAddOne")
    public BaseResponse dutyAddOne(@RequestBody TSysDuty tSysDuty) {
        return dutyService.dutyAddOne(tSysDuty);
    }

    @ApiOperation(value = "获取已经创建过的月份")
    @GetMapping("/getCreateDutyMon")
    public BaseResponse getCreateDutyMon() {
        return tSysDutyMonthService.getCreateDutyMon();
    }

    @ApiOperation(value = "值班人员整月添加审核状态修改接口")
    @PostMapping("/dutyAddMonth")
    public BaseResponse dutyAddMonth(@RequestBody TSysDutyMonth tSysDutyMonth) throws Exception {
        return tSysDutyMonthService.dutyAddMonth(tSysDutyMonth);
    }

    @ApiOperation(value = "值班人员整月添加审核 获取日历列表")
    @GetMapping("/getDutyList")
    public BaseResponse<List<Duty>> getDutyList(String id) throws Exception {
        return dutyService.getDutyList(id);
    }

    @ApiOperation(value = "获取值班月份信息")
    @GetMapping("/getDutyMonth")
    public BaseResponse<TSysDutyMonth> getDutyMonth(String id) throws Exception {
        return dutyService.getDutyMonth(id);
    }

    @ApiOperation(value = "按月提审失败 删除脏数据", notes = "")
    @GetMapping("/deleteDuty")
    public BaseResponse deleteDuty(String id) throws Exception {
        return dutyService.deleteDuty(id);
    }
}