package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 应急预案演练评价对象 t_emergency_rehearsal_evaluate
 *
 * @author testor-framework
 * @date 2022-12-07 09:48:28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_rehearsal_evaluate")
@ApiModel(value = "TEmergencyRehearsalEvaluate对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyRehearsalEvaluate extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id主键
     */
    @ApiModelProperty(value = "id主键")

    @TableId("id")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 应急演练id
     */
    @ApiModelProperty(value = "应急演练id")

    @TableField("rehearsal_id")
    private String rehearsalId;
    /**
     * 评价
     */
    @ApiModelProperty(value = "评价")

    @TableField("evaluate")
    private String evaluate;
    /**
     * 演练内容
     */
    @ApiModelProperty(value = "演练内容")

    @TableField("drill_contents")
    private String drillContents;
    /**
     * 评价人
     */
    @ApiModelProperty(value = "评价人")

    @TableField("appraiser")
    private String appraiser;
    /**
     * 评价时间
     */
    @ApiModelProperty(value = "评价时间")

    @TableField("evaluation_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date evaluationTime;

    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String REHEARSAL_ID = "rehearsal_id";
    public static final String EVALUATE = "evaluate";
    public static final String DRILL_CONTENTS = "drill_contents";
    public static final String APPRAISER = "appraiser";
    public static final String EVALUATION_TIME = "evaluation_time";


}
