package com.testor.module.emergency.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.emergency.model.domain.TContingencyPlan;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;


/**
 * 应急预案 删除参数对象
 *
 * @author testor-framework
 * @date 2022-10-18 09:50:43
 */

@Data
@ApiModel(value = "TContingencyPlan 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TContingencyPlanParam extends TContingencyPlan {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private Long limit;

	@ApiModelProperty(value = "当前页数")
	private Long page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;


	@ApiModelProperty(value = "修订起始时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date startTime;

	@ApiModelProperty(value = "修订结束时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date endTime;

	@ApiModelProperty(value = "企业id")
	private String orgIds;

	@ApiModelProperty(value = "预案状态")
	private String planStatus;


	private List<String> orgIdList;
}
