package com.testor.module.emergency.model.dto;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "TEmergencyGoodsDTO 列表查询参数对象")
public class TEmergencyGoodsDTO extends Page {
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    private List<String> orgId;
    /**
     * 物资类型(数据字典key)
     */
    @ApiModelProperty(value = "物资类型(数据字典id)")
    private String goodsTypeKey;
    /**
     * 物资名称(数据字典key)
     */
    @ApiModelProperty(value = "物资名称(数据字典id)")
    private String nameKey;
    /**
     * 有效日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "有效日期")
    private Date validityStartDate;
    /**
     * 有效日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "有效日期")
    private Date validityEndDate;
    /**
     * 页数
     */
    @ApiModelProperty(value = "页数")
    private Long page;

    /**
     * 每页数量
     */
    @ApiModelProperty(value = "每页数量")
    private Long limit;

    /**
     * 是否逾期 0否 1是
     */
    @ApiModelProperty(value = "点检是否逾期 0否 1是")
    private Integer isLate;
}
