package com.testor.module.hazard.dao;

import com.testor.module.hazard.model.domain.THazardWorkPlanMonitoringRecordProject;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 危险作业监测记录项目Mapper接口
 *
 * @author testor-framework
 * @date 2025-01-20
 */
public interface THazardWorkPlanMonitoringRecordProjectDao extends SuperDao<THazardWorkPlanMonitoringRecordProject>
{
    /**
     * 根据监测记录ID查询项目列表
     */
    List<THazardWorkPlanMonitoringRecordProject> selectByRecordId(@Param("recordId") String recordId);

    /**
     * 根据监测记录ID列表查询项目列表
     */
    List<THazardWorkPlanMonitoringRecordProject> selectByRecordIds(@Param("recordIds") List<String> recordIds);

    /**
     * 批量插入监测记录项目
     */
    int insertBatch(@Param("list") List<THazardWorkPlanMonitoringRecordProject> list);

    /**
     * 根据监测记录ID删除项目
     */
    int deleteByRecordId(@Param("recordId") String recordId);

    /**
     * 根据监测记录ID列表批量删除项目
     */
    int deleteByRecordIds(@Param("recordIds") List<String> recordIds);



}