package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 危险作业计划对象 t_hazard_work_plan
 * 
 * @author testor-framework
 * @date 2024-12-19 10:39:26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_work_plan")
@ApiModel(value = "THazardWorkPlan对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardWorkPlan extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
  /**
   * 编码
   */
  private String code;
  /**
 * 作业类型
 */
  @ApiModelProperty(value = "作业类型")

  @TableField("work_type")
  private String workType;
/**
 * 作业级别
 */
  @ApiModelProperty(value = "作业级别")

  @TableField("work_level")
  private String workLevel;
/**
 * 相关方作业
 */
  @ApiModelProperty(value = "相关方作业")

  @TableField("stakeholder_work")
  private String stakeholderWork;
/**
 * 涉及其他危险作业
 */
  @ApiModelProperty(value = "涉及其他危险作业")

  @TableField("involves_other_hazardous_work")
  private String involvesOtherHazardousWork;
/**
 * 是否法定节假日等特殊时期 0否 1是
 */
  @ApiModelProperty(value = "是否法定节假日等特殊时期 0否 1是")

  @TableField("is_holiday")
  private String isHoliday;
/**
 * 是否提级 0否 1是
 */
  @ApiModelProperty(value = "是否提级 0否 1是")

  @TableField("is_escalated")
  private String isEscalated;
/**
 * 提级后级别
 */
  @ApiModelProperty(value = "提级后级别")

  @TableField("escalated_level")
  private String escalatedLevel;
/**
 * 计划作业开始时间
 */
  @ApiModelProperty(value = "计划作业开始时间")

  @TableField("scheduled_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date scheduledStartTime;
/**
 * 计划作业结束时间
 */
  @ApiModelProperty(value = "计划作业结束时间")

  @TableField("scheduled_end_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date scheduledEndTime;

  @ApiModelProperty(value = "实际作业开始时间")
  @TableField("actual_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actualStartTime;

  @ApiModelProperty(value = "实际作业结束时间")
  @TableField("actual_end_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actualEndTime;

  @ApiModelProperty(value = "许可证审核状态")
  @TableField("license_status")
  private String licenseStatus;

  @ApiModelProperty(value = "许可证下一审核状态")
  @TableField("license_next_status")
  private String licenseNextStatus;

/**
 * 作业内容
 */
  @ApiModelProperty(value = "作业内容")

  @TableField("work_content")
  private String workContent;
/**
 * 作业地点
 */
  @ApiModelProperty(value = "作业地点")

  @TableField("work_location")
  private String workLocation;

  /**
   * 作业单位
   */
  @ApiModelProperty(value = "作业单位")

  @TableField("work_unit")
  private String workUnit;

  /**
   * 作业所在单位
   */
  @ApiModelProperty(value = "作业所在单位")

  @TableField("operation_unit")
  private String operationUnit;

/**
 * 作业主管单位
 */
  @ApiModelProperty(value = "作业主管单位")

  @TableField("work_supervisory_unit")
  private String workSupervisoryUnit;
/**
 * 作业现场负责人
 */
  @ApiModelProperty(value = "作业现场负责人")

  @TableField("work_site_responsible")
  private String workSiteResponsible;
/**
 * 作业现场负责人签名
 */
  @ApiModelProperty(value = "作业现场负责人签名")

  @TableField("work_site_responsible_signature")
  private String workSiteResponsibleSignature;
/**
 * 项目负责人
 */
  @ApiModelProperty(value = "项目负责人")

  @TableField("project_leader")
  private String projectLeader;
/**
 * 监护人
 */
  @ApiModelProperty(value = "监护人")

  @TableField("guardian")
  private String guardian;
/**
 * 监督人
 */
  @ApiModelProperty(value = "监督人")

  @TableField("supervisor")
  private String supervisor;
/**
 * 作业人
 */
  @ApiModelProperty(value = "作业人")

  @TableField("operator")
  private String operator;
/**
 * 风险分析参与人
 */
  @ApiModelProperty(value = "风险分析参与人")

  @TableField("risk_analysis_participant")
  private String riskAnalysisParticipant;
/**
 * 交底人
 */
  @ApiModelProperty(value = "交底人")

  @TableField("discloser")
  private String discloser;
/**
 * 推送该作业关闭信息时间（分钟）
 */
  @ApiModelProperty(value = "推送该作业关闭信息时间（分钟）" , example = "0")

  @TableField("early_reminder_time")
  private Long earlyReminderTime;
/**
 * 作业方案（含应急方案）
 */
  @ApiModelProperty(value = "作业方案（含应急方案）")

  @TableField("work_plan_file")
  private String workPlanFile;
/**
 * 计划关闭后作业现场负责人签字
 */
  @ApiModelProperty(value = "计划关闭后作业现场负责人签字")

  @TableField("work_site_responsible_end_signature")
  private String workSiteResponsibleEndSignature;
/**
 * 机构id
 */
  @ApiModelProperty(value = "机构id")

  @TableField("org_id")
  private String orgId;

  /**
   * 作业状态
   */
  @ApiModelProperty(value = "作业状态")
  @TableField("work_status")
  private String workStatus;

  /**
   * 流程id
   */
  @ApiModelProperty(value = "流程id")
  @TableField("process_id")
  private String processId;

  /**
   * 检查人员id
   */
  @ApiModelProperty(value = "检查人员id")
  @TableField("license_check_user")
  private String licenseCheckUser;

  @ApiModelProperty("是否提交 0否 1是")
  @TableField(exist = false)
  private String isSubmit;

  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "workType")
  @TableField(exist = false)
  private String workTypeName;

  @ApiModelProperty(value = "批次（第几次条件/交底确认）")
  @TableField(exist = false)
  private Integer batch;

  @ApiModelProperty(value = "作业取消审核意见")
  @TableField("cancel_opinion")
  private String cancelOpinion;
  /**
   * 作业撤回审核意见
   */
  @ApiModelProperty(value = "作业撤回审核意见")
  @TableField("revoke_opinion")
  private String revokeOpinion;

  @ApiModelProperty(value = "监护人签字")
  @TableField("guardian_signature")
  private String guardianSignature;

  @ApiModelProperty(value = "当前流程环节")
  @TableField(exist = false)
  private String currentTaskName;


  public static final String ID ="id";
  public static final String WORK_TYPE ="work_type";
  public static final String WORK_LEVEL ="work_level";
  public static final String STAKEHOLDER_WORK ="stakeholder_work";
  public static final String INVOLVES_OTHER_HAZARDOUS_WORK ="involves_other_hazardous_work";
  public static final String IS_HOLIDAY ="is_holiday";
  public static final String IS_ESCALATED ="is_escalated";
  public static final String ESCALATED_LEVEL ="escalated_level";
  public static final String SCHEDULED_START_TIME ="scheduled_start_time";
  public static final String SCHEDULED_END_TIME ="scheduled_end_time";
  public static final String ACTUAL_START_TIME ="actual_start_time";
  public static final String ACTUAL_END_TIME ="actual_end_time";
  public static final String WORK_CONTENT ="work_content";
  public static final String WORK_LOCATION ="work_location";
  public static final String WORK_SUPERVISORY_UNIT ="work_supervisory_unit";
  public static final String WORK_SITE_RESPONSIBLE ="work_site_responsible";
  public static final String WORK_SITE_RESPONSIBLE_SIGNATURE ="work_site_responsible_signature";
  public static final String PROJECT_LEADER ="project_leader";
  public static final String GUARDIAN ="guardian";
  public static final String SUPERVISOR ="supervisor";
  public static final String OPERATOR ="operator";
  public static final String RISK_ANALYSIS_PARTICIPANT ="risk_analysis_participant";
  public static final String DISCLOSER ="discloser";
  public static final String EARLY_REMINDER_TIME ="early_reminder_time";
  public static final String WORK_PLAN_FILE ="work_plan_file";
  public static final String WORK_SITE_RESPONSIBLE_END_SIGNATURE ="work_site_responsible_end_signature";
  public static final String ORG_ID ="org_id";
  public static final String WORK_STATUS ="work_status";
  public static final String CANCEL_OPINION ="cancel_opinion";


}
