package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 危险作业监测记录对象 t_hazard_work_plan_monitoring_record
 *
 * @author testor-framework
 * @date 2025-01-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_work_plan_monitoring_record")
@ApiModel(value = "THazardWorkPlanMonitoringRecord对象", description = "危险作业监测记录")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardWorkPlanMonitoringRecord extends SuperModel
{
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 危险作业id
     */
    @ApiModelProperty(value = "危险作业id")
    @TableField("plan_id")
    private String planId;

    /**
     * 检测位置
     */
    @ApiModelProperty(value = "检测位置")
    @TableField("detection_position")
    private String detectionPosition;

    /**
     * 结论
     */
    @ApiModelProperty(value = "结论")
    @TableField("conclusion")
    private String conclusion;

    /**
     * 现场照片
     */
    @ApiModelProperty(value = "现场照片")
    @TableField("scene_photo")
    private String scenePhoto;

    /**
     * 检测人签字
     */
    @ApiModelProperty(value = "检测人签字")
    @TableField("inspector_signature")
    private String inspectorSignature;

    /**
     * 检测时间
     */
    @ApiModelProperty(value = "检测时间")
    @TableField("inspector_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectorTime;

    /**
     * 监测项目列表（非数据库字段）
     */
    @ApiModelProperty(value = "监测项目列表")
    @TableField(exist = false)
    private List<THazardWorkPlanMonitoringRecordProject> projectList;

    // 常量定义
    public static final String ID = "id";
    public static final String PLAN_ID = "plan_id";
    public static final String DETECTION_POSITION = "detection_position";
    public static final String CONCLUSION = "conclusion";
    public static final String SCENE_PHOTO = "scene_photo";
    public static final String STATUS = "status";
    public static final String INSPECTOR_SIGNATURE = "inspector_signature";
    public static final String INSPECTOR_TIME = "inspector_time";
}